<?php if ('layout_ten' == $settings['layout_type']) : ?>
    <!-- landing page hero -->
    <div class="sw-landing-hero pt-180 pb-180">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="sw-landing-hero__left">
                        <?php if (!empty($settings['bannar_subtitle'])) : ?>
                            <span class="sw-landing-hero__subtitle"><?php echo wp_kses($settings['bannar_subtitle'], 'swiftcart_core_allowed_tags');  ?></span>
                        <?php endif; ?>
                        <?php if (!empty($settings['bannar_title'])) :
                            $this->add_inline_editing_attributes('bannar_title', 'none');
                            swiftcart_elementor_rendered_content($this, 'bannar_title', 'sw-landing-hero__title', $settings['section_title_tag_layout_one']);
                        endif;
                        ?>
                        <?php if (!empty($settings['bannar_info'])) : ?>
                            <p class="sw-landing-hero__info"><?php echo wp_kses($settings['bannar_info'], 'swiftcart_core_allowed_tags');  ?></p>
                        <?php endif; ?>
                        <div class="sw-landing-hero__btn">
                            <?php if (!empty($settings['button_label'])) : ?>
                                <div>
                                    <a class="swiftcart-btn" <?php esc_attr(!empty($settings['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['button_url']['url']); ?>"><?php echo esc_html($settings['button_label']); ?></a>
                                </div>
                            <?php endif; ?>
                            <?php if (!empty($settings['button_two_label'])) : ?>
                                <div>
                                    <a class="swiftcart-btn-black swiftcart-btn-black-large" <?php esc_attr(!empty($settings['button_two_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['button_two_url']['url']); ?>"><?php echo esc_html($settings['button_two_label']); ?></a>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="sw-landing-hero__thumb">
                            <?php if (!empty($settings['bannar_info_two'])) : ?>
                                <h4 class="sw-landing-hero__price"><?php echo wp_kses($settings['bannar_info_two'], 'swiftcart_core_allowed_tags');  ?></h4>
                            <?php endif; ?>
                            <?php swiftcart_elementor_rendered_image($settings, 'banner_image_author'); ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="sw-landing-hero__right sw-bg-circle">
                        <?php swiftcart_elementor_rendered_image($settings, 'banner_image'); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- landing page hero end -->
<?php endif; ?>