<?php if ('layout_three' == $settings['layout_type']) : ?>
    <div class="sw-banner-three sw-banner-seven pb-80">
        <div class="container">
            <div class="sw-banner-three__wrapper sw-banner-three__item bg-black">
                <div class="sw-banner-three__left">
                    <div class="sw-banner-three__content">
                        <?php if (!empty($settings['bannar_subtitle'])): ?>
                            <span class="sw-banner-three__subtitle"><?php echo esc_html($settings['bannar_subtitle']); ?></span>
                        <?php endif; ?>
                        <?php if (!empty($settings['bannar_title'])) :
                            $this->add_inline_editing_attributes('bannar_title', 'none');
                            swiftcart_elementor_rendered_content($this, 'bannar_title', 'sw-banner-three__title', $settings['section_title_tag_layout_one']);
                        endif;
                        ?>
                        <?php if (!empty($settings['bannar_title'])): ?>
                            <p class="sw-banner-three__info"><?php echo wp_kses($settings['bannar_info'], 'swiftcart_core_allowed_tags');  ?></p>
                        <?php endif; ?>
                        <?php if (!empty($settings['button_label'])) : ?>
                            <div class="sw-banner-three__btn">
                                <a class="swiftcart-btn" <?php esc_attr(!empty($settings['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['button_url']['url']); ?>"><?php echo esc_html($settings['button_label']); ?> <i class="icon-next"></i></a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="sw-banner-three__right">
                    <div class="sw-banner-three__img">
                        <?php swiftcart_elementor_rendered_image($settings, 'banner_image'); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>