<?php if ('layout_four' == $settings['layout_type']) : ?>
    <!-- Blog Slder area start -->
    <div class="blog-slider-page pt-120 pb-90 rel z-1">
        <div class="container">
            <div class="blog-page-slider">
                <?php while ($posts_query->have_posts()) :
                    $posts_query->the_post();
                ?>
                    <div class="blog-item">
                        <div class="blog-item__img">
                            <?php the_post_thumbnail('swiftcart_blog__416X267'); ?>
                            <div class="post-date">
                                <b><?php echo get_the_date('d') ?></b>
                                <span><?php echo get_the_date('M') ?></span>
                            </div>
                        </div>
                        <div class="blog-item__content">
                            <ul class="blog-meta">
                                <li><?php swiftcart_posted_by(); ?></li>
                                <li><i class="flaticon-bubble-chat"></i><?php comments_popup_link(); ?></li>
                            </ul>
                            <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                            <p><?php echo wp_kses(swiftcart_excerpt($settings['word_limit']['size']), 'swiftcart_core_allowed_tags'); ?></p>
                            <a href="<?php the_permalink() ?>" class="read-more"><?php esc_html_e('Read More', 'swiftcart'); ?></a>
                        </div>
                    </div>
                <?php endwhile; ?>
                <?php wp_reset_postdata(); ?>
            </div>
        </div>
    </div>
    <!-- Blog Slder area end -->

<?php endif; ?>