<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!-- blog post start  -->
    <div class="sw-blog-one pb-80 pt-80">
        <div class="container">
            <?php if ('yes' == $settings['heading_status']) : ?>
                <div class="sw-sec-heading sw-sec-heading-three text-center">
                    <?php if (!empty($settings['title'])) : ?>
                        <h3 class="sw-sec-heading__title sw-style-3"><?php echo wp_kses($settings['title'], 'swiftcart_core_allowed_tags');  ?></h3>
                    <?php endif; ?>
                    <?php if (!empty($settings['shape_one']['url'])): ?>
                        <div class="sw-sec-heading__shape">
                            <?php swiftcart_elementor_rendered_image($settings, 'shape_one'); ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <div class="row gutter-y-30">
                <?php
                $blog_post_one_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

                $args  = array(
                    'post_type'           => 'post',
                    'post_status'         => 'publish',
                    'ignore_sticky_posts' => 1,
                    'posts_per_page'      => $settings['post_count']['size'],
                    'paged' => $blog_post_one_query_paged
                );

                $args['orderby'] = $settings['orderby'];
                $args['order']   = $settings['order'];
                if (!empty($settings['exclude_cat'])) {
                    $args['category__not_in'] = $settings['exclude_cat'];
                }


                if (!empty($settings['select_cat'])) {
                    $args['tax_query'][] = array(
                        'taxonomy' => 'category',
                        'field'    => 'slug',
                        'terms'    => array_values($settings['select_cat'])
                    );
                }

                if (!empty($settings['select_tag'])) {
                    $args['tax_query'][] = array(
                        'taxonomy' => 'post_tag',
                        'field'    => 'slug',
                        'terms'    => array_values($settings['select_tag'])
                    );
                }

                $posts_query = new \WP_Query($args);
                ?>
                <?php while ($posts_query->have_posts()) :
                    $posts_query->the_post();
                    $category =  get_the_terms(get_the_ID(), 'category');
                ?>
                    <div class="col-md-6 col-xl-4">
                        <div class="sw-blog-one__item wow swfadeUp" data-wow-delay='100ms'>
                            <?php if (has_post_thumbnail()): ?>
                                <div class="sw-blog-one__thumb w-img">
                                    <a href="<?php the_permalink(); ?>">
                                        <?php the_post_thumbnail('swiftcart_blog_416X277'); ?>
                                    </a>
                                    <div class="sw-blog-one__meta-2">
                                        <?php swiftcart_posted_by(); ?>
                                        <span><?php echo get_the_date(); ?></span>
                                    </div>
                                </div>
                            <?php endif; ?>
                            <div class="sw-blog-one__content">
                                <?php $blog_title = get_the_title();
                                $blog_title_count = substr($blog_title, 0, $settings['post_title_count']['size']); ?>
                                <h3 class="sw-blog-one__title"><a href="<?php the_permalink() ?>"><?php echo $blog_title_count ?></a></h3>
                                <ul class="sw-blog-one__meta list-unstyled">
                                    <?php $cats =  get_the_category(); ?>
                                    <?php if (!empty($cats[0]->name)) : ?>
                                        <li class="sw-post-cat">
                                            <a href="<?php echo esc_url(get_category_link($cats[0]->term_id)); ?>"><i class="fas fa-tag"></i> <?php echo esc_html($cats[0]->name); ?></a>
                                        </li>
                                    <?php endif; ?>
                                    <li class="sw-post-comment">
                                        <span><i class="fas fa-comment"></i><?php comments_popup_link(); ?></span>
                                    </li>
                                    <?php $word_count = str_word_count(strip_tags(get_the_content()));
                                    $reading_speed = 200; // average reading speed in words per minute
                                    $minutes = ceil($word_count / $reading_speed);
                                    $read_time = $minutes . ' min read'; ?>
                                    <li><span class="sw-post-view"><i class="fa-solid fa-clock"></i> <?php echo esc_html($read_time, 'swiftcart'); ?></span></li>
                                </ul>
                                <p class="sw-blog-one__eswept"><?php echo swiftcart_excerpt($settings['word_limit']['size']); ?></p>

                                <a href="<?php the_permalink(); ?>" class="swiftcart-btn swiftcart-border-btn"><?php esc_html_e('Read More', 'swiftcart'); ?></a>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
                <?php wp_reset_postdata(); ?>
            </div>
            <?php if ('yes' == $settings['pagination_status']) : ?>
                <div class="sw-pagination pt-50 d-flex align-items-center justify-content-center">
                    <?php swiftcart_custom_query_pagination($blog_post_one_query_paged, $posts_query->max_num_pages); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <!-- blog post end  -->
<?php endif; ?>