<?php if ('layout_three' == $settings['layout_type']) : ?>

    <div class="blog-area-three pb-90 rel z-1">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-7 col-lg-8 col-md-10">
                    <div class="section-title text-center mb-60">
                        <?php if (!empty($settings['sub_title'])) : ?>
                            <span class="section-title__subtitle mb-10"><?php echo esc_html($settings['sub_title']); ?></span>
                        <?php endif; ?>
                        <?php if (!empty($settings['title'])) : ?>
                            <h2><?php echo wp_kses($settings['title'], 'swiftcart_core_allowed_tags');  ?></h2>
                        <?php endif; ?>
                        <?php if (!empty($settings['summary'])) : ?>
                            <p class="text-white"><?php echo wp_kses($settings['summary'], 'swiftcart_core_allowed_tags');  ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="row justify-content-center">
                <?php while ($posts_query->have_posts()) :
                    $posts_query->the_post();
                    $category =  get_the_terms(get_the_ID(), 'category');
                ?>
                    <div class="col-xl-4 col-md-6">
                        <div class="blog-item--three">
                            <div class="blog-item__img">
                                <?php the_post_thumbnail('swiftcart_blog__416X267'); ?>
                                <div class="post-date">
                                    <b><?php echo get_the_date('d') ?></b>
                                    <span><?php echo get_the_date('M') ?></span>
                                </div>
                            </div>
                            <div class="blog-item__content">
                                <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                <a href="<?php the_permalink() ?>" class="read-more-two"><?php esc_html_e('Read More', 'swiftcart'); ?></a>
                            </div>
                            <ul class="blog-item__meta">
                                <li><?php swiftcart_posted_by(); ?></li>
                                <li class="line"></li>
                                <li><i class="flaticon-bubble-chat"></i><?php comments_popup_link(); ?></li>
                            </ul>
                        </div>
                    </div>
                <?php endwhile; ?>
                <?php wp_reset_postdata(); ?>
            </div>
        </div>
        <?php if (!empty($settings['blog_shape']['url'])) : ?>
            <img class="blog-shape-one top_image_bounce" src="<?php echo esc_url($settings['blog_shape']['url']); ?>" alt="<?php echo esc_attr(swiftcart_core_get_thumbnail_alt($settings['blog_shape']['id'])); ?>">
        <?php endif; ?>
    </div>
<?php endif; ?>