<?php if ('layout_two' == $settings['layout_type']) : ?>
    <!-- blog area start -->
    <div class="blog-area pd-top-118 pd-bottom-90">
        <div class="container">
            <?php if ('yes' == $settings['heading_status']) : ?>
                <div class="section-title text-center">
                    <?php if (!empty($settings['sub_title'])) : ?>
                        <h6><?php echo esc_html($settings['sub_title']); ?></h6>
                    <?php endif; ?>
                    <?php if (!empty($settings['title'])) : ?>
                        <h2><?php echo wp_kses($settings['title'], 'swiftcart_core_allowed_tags');  ?></h2>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <div class="row">
                <?php
                $blog_post_one_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

                $args  = array(
                    'post_type'           => 'post',
                    'post_status'         => 'publish',
                    'ignore_sticky_posts' => 1,
                    'posts_per_page'      => $settings['post_count']['size'],
                    'paged' => $blog_post_one_query_paged
                );

                $args['orderby'] = $settings['orderby'];
                $args['order']   = $settings['order'];
                if (!empty($settings['exclude_cat'])) {
                    $args['category__not_in'] = $settings['exclude_cat'];
                }


                if (!empty($settings['select_cat'])) {
                    $args['tax_query'][] = array(
                        'taxonomy' => 'category',
                        'field'    => 'slug',
                        'terms'    => array_values($settings['select_cat'])
                    );
                }

                if (!empty($settings['select_tag'])) {
                    $args['tax_query'][] = array(
                        'taxonomy' => 'post_tag',
                        'field'    => 'slug',
                        'terms'    => array_values($settings['select_tag'])
                    );
                }

                $posts_query = new \WP_Query($args);
                ?>
                <?php while ($posts_query->have_posts()) :
                    $posts_query->the_post();
                    $category =  get_the_terms(get_the_ID(), 'category');
                ?>
                    <div class="col-lg-4 col-md-6">
                        <div class="single-product-wrap style-2">
                            <?php if (has_post_thumbnail()) : ?>
                                <div class="thumb">
                                    <?php the_post_thumbnail('swiftcart_blog_416X267'); ?>
                                </div>
                            <?php endif; ?>
                            <div class="product-details-inner">
                                <ul class="meta-inner">
                                    <li><i class="fa fa-user"></i><?php esc_html_e("By", 'swiftcart-core'); ?> <?php the_author(); ?></li>
                                    <li><i class="fa fa-calendar-alt"></i><?php echo get_the_date(); ?></li>
                                </ul>
                                <?php $blog_title = get_the_title();
                                $blog_title_count = substr($blog_title, 0, $settings['post_title_count']['size']);; ?>
                                <h4><a href="<?php the_permalink() ?>"><?php echo $blog_title_count ?></a></h4>
                                <p><?php echo wp_kses(swiftcart_excerpt($settings['word_limit']['size']), 'swiftcart_core_allowed_tags'); ?></p>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
                <?php wp_reset_postdata(); ?>
            </div>
            <?php if ('yes' == $settings['pagination_status']) : ?>
                <div class="pagination wp-pagination pt-20">
                    <?php swiftcart_custom_query_pagination($blog_post_one_query_paged, $posts_query->max_num_pages); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <!-- Blog area end -->
<?php endif; ?>