<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!-- seller one start  -->
    <div class="sw-brand-one">
        <div class="container">
            <div class="sw-brand-one__wrapper">
                <div class="row gutter-y-20">
                    <?php if (is_array($settings['brand_list'])) : ?>
                        <?php foreach ($settings['brand_list'] as $item) : ?>
                            <div class="col-sm-6 col-md-3 col-xl-2">
                                <div class="sw-brand-one__item">
                                    <?php if (!empty($item['url']['url'])) : ?>
                                        <a href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?>><?php swiftcart_elementor_rendered_image($item, 'brand_logo'); ?></a>
                                    <?php else : ?>
                                        <?php swiftcart_elementor_rendered_image($item, 'brand_logo'); ?>
                                    <?php endif; ?>
                                    <?php if (!empty($item['brand_name'])): ?>
                                        <h3 class="sw-brand-one__title el-brand-title"><a href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?>><?php echo esc_html($item['brand_name']); ?></a></h3>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <!-- seller one end  -->
<?php endif; ?>