<?php if ('layout_one' == $settings['layout_type']) : ?>

    <!--======  Start CTA Section  ======-->
    <section class="cta-section">
        <div class="container">
            <div class="cta-wrapper_one" style="background: url(<?php echo esc_url($settings['bg_image']['url']); ?>);">
                <div class="row align-items-center">
                    <div class="col-lg-6">
                        <!--=== CTA Content Box ===-->
                        <div class="cta-one_content-box wow fadeInLeft">
                            <?php if (!empty($settings['title'])) : ?>
                                <h2><?php echo wp_kses($settings['title'], 'swiftcart_core_allowed_tags');  ?></h2>
                            <?php endif; ?>
                            <?php if (!empty($settings['sec_summary'])) : ?>
                                <p><?php echo wp_kses($settings['sec_summary'], 'swiftcart_core_allowed_tags');  ?></p>
                            <?php endif; ?>
                            <?php if (!empty($settings['button_label'])) : ?>
                                <a class="theme-btn gradient-btn" <?php esc_attr(!empty($settings['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['button_url']['url']); ?>"><?php echo esc_html($settings['button_label']); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <!--=== CTA Image ===-->
                        <div class="cta-one_image-box p-r z-1 text-xl-end">
                            <?php swiftcart_elementor_rendered_image($settings, 'layout_one_image_one', 'image-one'); ?>
                            <?php swiftcart_elementor_rendered_image($settings, 'layout_one_image_two', 'image-two'); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section><!--======  End CTA Section  ======-->

<?php endif; ?>