<?php if ('layout_three' == $settings['layout_type']) : ?>
    <!--======  Start CTA Section  ======-->
    <section class="cta-section">
        <div class="cta-bg-wrapper-two black-dark-bg bg_cover pt-50 pb-30" style="background-image: url(<?php echo esc_url($settings['layout_three_bg_image']['url']); ?>);">
            <div class="shape shape-one"><span class="circle"></span></div>
            <div class="shape shape-two"><span class="circle"></span></div>
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-lg-6">
                        <!--=== CTA Content Box ===-->
                        <div class="cta-one_content-box mb-20 wow fadeInLeft">
                            <h2><?php echo wp_kses($settings['layout_three_title'], 'swiftcart_core_allowed_tags'); ?></h2>
                            <p><?php echo wp_kses($settings['layout_three_summary'], 'swiftcart_core_allowed_tags'); ?></p>
                            <?php if (!empty($settings['layout_three_button_label'])) : ?>
                                <a class="theme-btn gradient-btn" <?php esc_attr(!empty($settings['layout_three_button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['layout_three_button_url']['url']); ?>"><?php echo esc_html($settings['layout_three_button_label']); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <!--=== CTA Image ===-->
                        <div class="cta-one_image-box text-end p-r z-1 mb-20 wow fadeInRight swiftcart-tilt" data-tilt-options='{ "glare": false, "maxGlare": 0, "maxTilt": 5, "speed": 700, "scale": 1 }'>
                            <?php swiftcart_elementor_rendered_image($settings, 'layout_one_img'); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section><!--======  End CTA Section  ======-->
    <!--======  Start Faqs Section  ======-->
<?php endif; ?>