<?php if ('layout_four' == $settings['layout_type']) : ?>

    <!-- Our events area start -->
    <div class="our-events-slider pt-120 pb-80 rel z-1">
        <div class="container">
            <div class="events-slider-active">
                <?php
                if ($post_query->have_posts()) :
                    $index = 1;
                    while ($post_query->have_posts()) : $post_query->the_post();
                        $event_meta = get_post_meta(get_the_ID(), 'swiftcart_event_meta', true);
                ?>
                        <div class="event-item-three item--<?php echo esc_attr($index); ?>">
                            <div class="image">
                                <?php the_post_thumbnail('swiftcart_event_373X240'); ?>
                            </div>
                            <div class="content">
                                <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                <ul class="blog-meta">
                                    <li><i class="<?php echo esc_attr($event_meta['time_icon']); ?>"></i> <a href="#"><?php echo get_the_date(); ?></a></li>
                                    <li><i class="<?php echo esc_attr($event_meta['location_icon']); ?>"></i> <a href="<?php echo esc_url($event_meta['event_location_name_link']['url']); ?>"><?php echo esc_html($event_meta['event_location_name_link']['text']); ?></a></li>
                                </ul>
                                <p><?php echo wp_kses(swiftcart_excerpt($settings['word_limit']['size']), 'swiftcart_core_allowed_tags'); ?></p>
                                <a class="event-btn" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'swiftcart-core'); ?><i class="flaticon-chevron"></i></a>
                            </div>
                        </div>
                <?php $index++;
                    endwhile;
                endif; ?>
            </div>
        </div>
    </div>
    <!-- Our events area end -->

<?php endif; ?>