<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!-- Our Event area start -->
    <div class="our-event-area pt-120 pb-95 rel z-1">
        <div class="container">
            <?php if ('yes'  != $settings['hide_top_section']) : ?>
                <div class="row justify-content-center">
                    <div class="col-xl-6 col-lg-8 col-md-10">
                        <div class="section-title text-center mb-65">
                            <?php if (!empty($settings['sub_title'])) : ?>
                                <span class="section-title__subtitle mb-10"><?php echo esc_html($settings['sub_title']); ?></span>
                            <?php endif; ?>
                            <?php if (!empty($settings['title'])) : ?>
                                <h3><?php echo wp_kses($settings['title'], 'swiftcart_core_allowed_tags'); ?></h3>
                            <?php endif; ?>
                            <?php if (!empty($settings['summary'])) : ?>
                                <p><?php echo esc_html($settings['summary']); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <div class="row events-active">
                <?php
                if ($post_query->have_posts()) :
                    while ($post_query->have_posts()) : $post_query->the_post();
                        $event_meta = get_post_meta(get_the_ID(), 'swiftcart_event_meta', true);

                ?>
                        <?php if (has_post_thumbnail()) : ?>
                            <div class="col-xl-4 col-md-6 item">
                                <div class="event-item">
                                    <?php the_post_thumbnail(); ?>
                                    <div class="event-item__hover">
                                        <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                        <ul>
                                            <li><i class="<?php echo esc_attr($event_meta['time_icon']); ?>"></i> <span><?php echo get_the_date(); ?></span></li>
                                            <li><i class="<?php echo esc_attr($event_meta['location_icon']); ?>"></i> <span><?php echo esc_html($event_meta['event_location_name_link']['text']); ?></span></li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                <?php endwhile;
                endif; ?>
            </div>
        </div>
    </div>
    <!-- Our Event area end -->
<?php endif; ?>