<?php if ('layout_three' == $settings['layout_type']) : ?>

    <!-- Event area start -->
    <div class="event-area-three overlay bgs-cover pt-120 pb-80 rel z-1" style="background-image: url(<?php echo esc_url($settings['bg_image']['url']); ?>)">
        <div class="container">
            <div class="row gap-40">
                <?php if ('yes'  != $settings['hide_left_section']) : ?>
                    <div class="col-lg-4">
                        <div class="event-three-content mt-50 rmt-0 mb-30 rmb-65">
                            <div class="section-title mb-30">
                                <?php if (!empty($settings['sub_title'])) : ?>
                                    <span class="section-title__subtitle mb-15"><?php echo esc_html($settings['sub_title']); ?></span>
                                <?php endif; ?>
                                <?php if (!empty($settings['title'])) : ?>
                                    <h3><?php echo wp_kses($settings['title'], 'swiftcart_core_allowed_tags'); ?></h3>
                                <?php endif; ?>
                                <?php if (!empty($settings['summary'])) : ?>
                                    <p><?php echo wp_kses($settings['summary'], 'swiftcart_core_allowed_tags'); ?></p>
                                <?php endif; ?>
                                <?php if (!empty($settings['summary_two'])) : ?>
                                    <p><?php echo wp_kses($settings['summary_two'], 'swiftcart_core_allowed_tags'); ?></p>
                                <?php endif; ?>
                            </div>
                            <?php if (!empty($settings['button_label'])) : ?>
                                <a class="btn ml-5 mt-25" href="<?php echo esc_url($settings['button_url']['url']); ?>"><?php echo esc_html($settings['button_label']); ?></a>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="col-lg-8">
                    <div class="event-three-slider">
                        <?php
                        if ($post_query->have_posts()) :
                            $index = 1;
                            while ($post_query->have_posts()) : $post_query->the_post();
                                $event_meta = get_post_meta(get_the_ID(), 'swiftcart_event_meta', true);
                        ?>
                                <div class="event-item-three item--<?php echo esc_attr($index); ?>">
                                    <div class="image">
                                        <?php the_post_thumbnail('swiftcart_event_388X250'); ?>
                                    </div>
                                    <div class="content">
                                        <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
                                        <ul class="blog-meta">
                                            <li><i class="<?php echo esc_attr($event_meta['time_icon']); ?>"></i> <a href="<?php the_permalink(); ?>"><?php echo get_the_date(); ?></a></li>

                                            <li><i class="<?php echo esc_attr($event_meta['location_icon']); ?>"></i> <a href="<?php echo esc_url($event_meta['event_location_name_link']['url']); ?>"><?php echo esc_html($event_meta['event_location_name_link']['text']); ?></a></li>
                                        </ul>
                                        <p><?php echo wp_kses(swiftcart_excerpt($settings['word_limit']['size']), 'swiftcart_core_allowed_tags'); ?></p>
                                        <a class="event-btn" href="<?php the_permalink(); ?>"><?php esc_html_e('Read more', 'swiftcart-core'); ?><i class="flaticon-chevron"></i></a>
                                    </div>
                                </div>
                        <?php $index++;
                            endwhile;
                        endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Event area end -->

<?php endif; ?>