<?php if ('layout_two' == $settings['layout_type']) : ?>

    <!-- Our Event area start -->
    <div class="our-event-two bgs-cover pt-120 pb-90 rel z-1" style="background-image: url(<?php echo esc_url($settings['bg_image']['url']); ?>)">
        <div class="container container-1090">
            <?php if ('yes'  != $settings['hide_top_section']) : ?>
                <div class="row justify-content-center">
                    <div class="col-xl-7 col-lg-8 col-md-10">
                        <div class="section-title text-center mb-55">
                            <?php if (!empty($settings['sub_title'])) : ?>
                                <span class="section-title__subtitle mb-10"><?php echo esc_html($settings['sub_title']); ?></span>
                            <?php endif; ?>
                            <?php if (!empty($settings['title'])) : ?>
                                <h3><?php echo wp_kses($settings['title'], 'swiftcart_core_allowed_tags'); ?></h3>
                            <?php endif; ?>
                            <?php if (!empty($settings['summary'])) : ?>
                                <p><?php echo esc_html($settings['summary']); ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <div class="row justify-content-center">
                <?php
                if ($post_query->have_posts()) :
                    $index = 1;
                    while ($post_query->have_posts()) : $post_query->the_post();
                        $event_meta = get_post_meta(get_the_ID(), 'swiftcart_event_meta', true);
                ?>
                        <div class="col-lg-6">
                            <div class="event-two-item event-two-item--<?php echo esc_attr($index) ?>">
                                <div class="image">
                                    <?php the_post_thumbnail('swiftcart_event_119X109'); ?>
                                </div>
                                <div class="content">
                                    <h5><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
                                    <ul>
                                        <li><i class="<?php echo esc_attr($event_meta['location_icon']); ?>"></i><?php echo esc_html($event_meta['event_location_name_link']['text']); ?></li>
                                        <li><i class="<?php echo esc_attr($event_meta['time_icon']); ?>"></i><?php echo get_the_time('l, g:i a'); ?></li>
                                    </ul>
                                </div>
                                <div class="date">
                                    <b><?php echo get_the_date('j'); ?></b>
                                    <span><?php echo get_the_date('M'); ?></span>
                                </div>
                            </div>
                        </div>
                <?php $index++;
                    endwhile;
                endif; ?>
            </div>
        </div>
    </div>
    <!-- Our Event area end -->


<?php endif; ?>