<?php if ('layout_four' == $settings['layout_type']) : ?>

    <div class="faq-page-area-two py-120">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xl-8 col-lg-8">
                    <div class="section-title text-center mb-45">
                        <?php if (!empty($settings['sub_title'])) : ?>
                            <span class="section-title__subtitle mb-10"><?php echo esc_html($settings['sub_title']); ?></span>
                        <?php endif; ?>
                        <?php if (!empty($settings['title'])) : ?>
                            <h2><?php echo wp_kses($settings['title'], 'swiftcart_core_allowed_tags'); ?></h2>
                        <?php endif; ?>
                        <?php if (!empty($settings['summary'])) : ?>
                            <p><?php echo esc_html($settings['summary']); ?></p>
                        <?php endif; ?>
                    </div>
                    <?php if (is_array($settings['faq_list'])) : ?>
                        <div class="faq-accordion" id="faqAccordionFour">
                            <?php foreach ($settings['faq_list'] as $index => $item) :
                                $show = ($index == 0) ? 'show' : '';
                                $collapsed = ($index != 0) ? 'collapsed' : ''; ?>
                                <?php if (!empty($item['question'])) : ?>
                                    <div class="accordion-item">
                                        <h4 class="accordion-header" id="fourHeadingOne-<?php echo esc_attr($index); ?>">
                                            <button class="<?php echo esc_attr($collapsed); ?>" type="button" data-bs-toggle="collapse" data-bs-target="#fourCollapseOne-<?php echo esc_attr($index); ?>" aria-expanded="true" aria-controls="fourCollapseOne-<?php echo esc_attr($index); ?>">
                                                <?php echo esc_html($item['question']); ?>
                                            </button>
                                        </h4>
                                        <div id="fourCollapseOne-<?php echo esc_attr($index); ?>" class="accordion-collapse collapse <?php echo esc_attr($show); ?>" aria-labelledby="fourHeadingOne-<?php echo esc_attr($index); ?>" data-bs-parent="#faqAccordionFour-<?php echo esc_attr($index); ?>">
                                            <div class="accordion-body">
                                                <?php echo esc_html($item['answer']); ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>