<?php if ('layout_one' == $settings['layout_type']) : ?>
    <div class="sw-faq-one pb-80 pt-80">
        <div class="container">
            <div class="row">
                <div class="col-lg-5">
                    <div class="sw-faq-one__left">
                        <div class="sw-faq-one__search">
                            <form action="<?php echo home_url('/'); ?>" role="search" method="get">
                                <input type="text" value="<?php echo get_search_query(); ?>" name="s" id="s" placeholder="<?php esc_attr_e('Search here', 'swiftcart-core'); ?>" />
                                <button type="submit"><i class="icon-magnifying-glass"></i></button>
                            </form>
                        </div>
                        <div class="sw-faq-one__form">
                            <?php if (!empty($settings['layout_one_sec_title'])) : ?>
                                <h3 class="sw-faq-one__form__title"><?php echo wp_kses($settings['layout_one_sec_title'], 'swiftcart_core_allowed_tags'); ?></h3>
                            <?php endif; ?>
                            <?php if (!empty($settings['contact_shortcode'])) : ?>
                                <?php echo do_shortcode('[contact-form-7 id="' . $settings['contact_shortcode'] . '" ]'); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-7">
                    <div class="sw-faq-one__right">
                        <div class="sw-faq-one__title mb-35">
                            <?php if (!empty($settings['layout_one_sec_title_two'])) : ?>
                                <h3 class="sw-sec-heading__title"><?php echo wp_kses($settings['layout_one_sec_title_two'], 'swiftcart_core_allowed_tags'); ?></h3>
                            <?php endif; ?>
                        </div>

                        <div class="sw-accordion-grp swiftcart-accordion swiftcart-accordion-active"
                            data-grp-name="swiftcart-accordion-one">
                            <?php foreach ($settings['layout_one_faq_list'] as $index => $item) :
                                $show = ($index == 0) ? 'active' : ''; ?>
                                <div class="sw-accordion <?php echo esc_attr($show); ?>">
                                    <div class="sw-accordion-title">
                                        <h4 class="sw-accordion-question"><?php echo esc_html($item['question']); ?></h4>
                                        <span><i class="icon-arrow-right"></i></span>
                                    </div>
                                    <div class="sw-accordion-content">
                                        <div class="sw-accordion-answer">
                                            <p><?php echo wp_kses($item['answer'], 'swiftcart_core_allowed_tags'); ?></p>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>