<?php if ('layout_three' == $settings['layout_type']) : ?>

    <?php $unique_id = uniqid(); ?>
    <!--======  Start Faqs Section  ======-->
    <section class="faqs-section pt-115 pb-80">
        <div class="container">
            <div class="row">
                <div class="col-lg-4">
                    <!--======  Sidebar Nav Widget  ======-->
                    <div class="sidebar-nav-widget style-two mb-40">
                        <h6><?php echo esc_html($settings['layout_three_form_title']); ?></h6>
                        <div class="contact-form">
                            <?php if (!empty($settings['contact_shortcode'])) : ?>
                                <?php echo do_shortcode('[contact-form-7 id="' . $settings['contact_shortcode'] . '" ]'); ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-8">
                    <!--======  Tab content  ======-->
                    <div class="section-content-box">
                        <div class="accordion" id="accordionTwo-<?php echo esc_attr($unique_id); ?>">
                            <!--=== Accordion Card ===-->
                            <?php foreach ($settings['layout_three_faq_list'] as $index => $item) :
                                $show = ($index == 0) ? 'show' : '';
                                $collapsed = ($index != 0) ? 'collapsed' : ''; ?>
                                <div class="accordion-card style-two mb-15">
                                    <div class="accordion-header">
                                        <h6 class="accordion-title collapsed" data-bs-toggle="collapse" data-bs-target="#collapse-1<?php echo esc_attr($index); ?>" aria-expanded="true">
                                            <?php echo esc_html($item['question']); ?>
                                        </h6>
                                    </div>
                                    <div id="collapse-1<?php echo esc_attr($index); ?>" class="accordion-collapse collapse <?php echo esc_attr($show); ?>" data-bs-parent="#accordionTwo-<?php echo esc_attr($unique_id); ?>">
                                        <div class="accordion-content">
                                            <p><?php echo wp_kses($item['answer'], 'swiftcart_core_allowed_tags'); ?></p>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section><!--======  End Faqs Section  ======-->
<?php endif; ?>