<?php if ('layout_two' == $settings['layout_type']) : ?>
    <?php $unique_id = uniqid(); ?>
    <!--======  Start Faqs Section  ======-->
    <section class="faqs-section pt-110 pb-70">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-xl-5">
                    <div class="faq-one_image-box mb-50 wow fadeInLeft swiftcart-tilt" data-tilt-options='{ "glare": false, "maxGlare": 0, "maxTilt": 5, "speed": 700, "scale": 1 }'>
                        <?php swiftcart_elementor_rendered_image($settings, 'layout_one_image_one'); ?>
                    </div>
                </div>
            <div class="col-xl-7">
                    <div class="section-content-box mb-50 wow fadeInRight">
                        <div class="section-title mb-50">
                            <?php if (!empty($settings['layout_one_sec_sub_title'])) : ?>
                                <span class="sub-title"><?php swiftcart_elementor_rendered_image($settings, 'layout_one_subtitle_shape'); ?><?php echo esc_html($settings['layout_one_sec_sub_title']); ?></span>
                            <?php endif; ?>
                            <?php if (!empty($settings['layout_one_sec_title'])) : ?>
                                <h2><?php echo wp_kses($settings['layout_one_sec_title'], 'swiftcart_core_allowed_tags'); ?></h2>
                            <?php endif; ?>
                            <p><?php echo wp_kses($settings['layout_one_sec_summary'], 'swiftcart_core_allowed_tags'); ?></p>
                        </div>
                        <div class="accordion" id="accordionOne-<?php echo esc_attr($unique_id); ?>">
                            <?php foreach ($settings['layout_one_faq_list'] as $index => $item) :
                                $show = ($index == 0) ? 'show' : '';
                                $collapsed = ($index != 0) ? 'collapsed' : ''; ?>
                                <div class="accordion-card style-two mb-15">
                                    <div class="accordion-header">
                                        <h6 class="accordion-title <?php echo esc_attr($collapsed); ?>" data-bs-toggle="collapse" data-bs-target="#collapse-<?php echo esc_attr($index); ?>" aria-expanded="true">
                                            <?php echo esc_html($item['question']); ?>
                                        </h6>
                                    </div>
                                    <div id="collapse-<?php echo esc_attr($index); ?>" class="accordion-collapse collapse <?php echo esc_attr($show); ?>" data-bs-parent="#accordionOne-<?php echo esc_attr($unique_id); ?>">
                                        <div class="accordion-content">
                                            <p><?php echo wp_kses($item['answer'], 'swiftcart_core_allowed_tags'); ?></p>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section><!--======  End Faqs Section  ======-->
<?php endif; ?>