<?php if ('layout_five' == $settings['layout_type']) : ?>
    <section class="core-features pt-115">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <!--===  Section Title  ===-->
                    <div class="section-title text-center mb-50 wow fadeInDown">
                        <span class="sub-title"><?php swiftcart_elementor_rendered_image($settings, 'layout_five_subtitle_icon'); ?>
                            <?php echo wp_kses($settings['layout_five_sec_sub_title'], 'swiftcart_core_allowed_tags'); ?>
                            <?php swiftcart_elementor_rendered_image($settings, 'layout_five_subtitle_icon'); ?>
                        </span>
                        <h2><?php echo wp_kses($settings['layout_five_sec_title'], 'swiftcart_core_allowed_tags'); ?></h2>
                        <p><?php echo wp_kses($settings['layout_five_sec_summary'], 'swiftcart_core_allowed_tags'); ?></p>
                    </div>
                </div>
            </div>
            <div class="row">
                <?php foreach ($settings['layout_five_features_list'] as $index => $item) : ?>
                    <div class="col-xl-4 col-md-6 col-sm-12">
                        <!--===  Iconic Info Box  ===-->
                        <div class="iconic-info-box style-three mb-30 wow fadeInUp">
                            <div class="icon">
                                <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true'], 'i'); ?>
                            </div>
                            <div class="content">
                                <h6><?php echo wp_kses($item['title'], 'swiftcart_core_allowed_tags') ?></h6>
                                <p><?php echo wp_kses($item['summary'], 'swiftcart_core_allowed_tags') ?></p>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section><!--======  End Core Features Section  ======-->
    <!--======  Start Faqs Section  ======-->
<?php endif; ?>