<?php if ('layout_one' == $settings['layout_type']) : ?>
    <div class="sw-product-feature pt-80 pb-80 fix" data-bg-color="#E7F2FF">
        <div class="container">
            <div class="sw-sec-heading sw-sec-heading__three text-center">
                <?php if (!empty($settings['layout_one_sec_title'])): ?>
                    <h3 class="sw-sec-heading__title"><?php echo wp_kses($settings['layout_one_sec_title'], 'swiftcart_core_allowed_tags'); ?></h3>
                <?php endif; ?>
                <?php if (!empty($settings['layout_one_sec_summary'])): ?>
                    <p class="sw-sec-heading__summary"><?php echo wp_kses($settings['layout_one_sec_summary'], 'swiftcart_core_allowed_tags'); ?></p>
                <?php endif; ?>
            </div>
            <div class="row align-items-center gutter-x-80">
                <div class="col-lg-4">
                    <?php if (is_array($settings['features_list'])) : ?>
                        <?php foreach ($settings['features_list'] as $item) : ?>
                            <div class="sw-product-feature__item">
                                <div class="sw-product-feature__icon" data-bg-color="<?php echo esc_attr($item['bg_color']) ?>">
                                    <span><?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true'], 'i'); ?></span>
                                </div>
                                <div class="sw-product-feature__content">
                                    <?php if (!empty($item['title'])) : ?>
                                        <h3 class="sw-product-feature__title"><?php echo wp_kses($item['title'], 'swiftcart_core_allowed_tags'); ?></h3>
                                    <?php endif; ?>
                                    <?php if (!empty($item['summary'])) : ?>
                                        <p class="sw-sec-heading__summary"><?php echo wp_kses($item['summary'], 'swiftcart_core_allowed_tags'); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
                <div class="col-lg-4">
                    <div class="sw-product-feature__img text-center">
                        <?php swiftcart_elementor_rendered_image($settings, 'layout_one_image'); ?>
                    </div>
                </div>
                <div class="col-lg-4">
                    <?php if (is_array($settings['features_list_two'])) : ?>
                        <?php foreach ($settings['features_list_two'] as $item) : ?>
                            <div class="sw-product-feature__item">
                                <div class="sw-product-feature__icon" data-bg-color="<?php echo esc_attr($item['bg_color']) ?>">
                                    <span><?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true'], 'i'); ?></span>
                                </div>
                                <div class="sw-product-feature__content">
                                    <?php if (!empty($item['title'])) : ?>
                                        <h3 class="sw-product-feature__title"><?php echo wp_kses($item['title'], 'swiftcart_core_allowed_tags'); ?></h3>
                                    <?php endif; ?>
                                    <?php if (!empty($item['summary'])) : ?>
                                        <p class="sw-sec-heading__summary"><?php echo wp_kses($item['summary'], 'swiftcart_core_allowed_tags'); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

<?php endif; ?>