<?php if ('layout_six' == $settings['layout_type']) : ?>
    <!--======  Start Features Section  ======-->
    <section class="features-section pb-70">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-7">
                    <div class="section-title mb-50 wow fadeInLeft">
                        <span class="sub-title style-one">
                            <?php echo wp_kses($settings['layout_six_sec_sub_title'], 'swiftcart_core_allowed_tags'); ?>
                        </span>
                        <h2><?php echo wp_kses($settings['layout_six_sec_title'], 'swiftcart_core_allowed_tags'); ?></h2>
                    </div>
                </div>
                <div class="col-lg-5">
                    <div class="text-box text-end mb-50 wow fadeInRight">
                        <p><?php echo wp_kses($settings['layout_six_sec_summary'], 'swiftcart_core_allowed_tags'); ?></p>
                    </div>
                </div>
            </div>
            <div class="row justify-content-center">
                <?php foreach ($settings['layout_six_features_list'] as $index => $item) : ?>
                    <div class="col-lg-4 col-md-6 col-sm-12">
                        <div class="iconic-info-box style-four mb-40 wow fadeInUp">
                            <div class="icon">
                                <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true'], 'i'); ?>
                            </div>
                            <div class="content">
                                <h5><?php echo wp_kses($item['title'], 'swiftcart_core_allowed_tags') ?></h5>
                                <p><?php echo wp_kses($item['summary'], 'swiftcart_core_allowed_tags') ?></p>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </section><!--======  End Features Section  ======-->
<?php endif; ?>