<?php if ('layout_three' == $settings['layout_type']) : ?>
    <div class="sw-landing-download pt-80" data-bg="<?php echo esc_url($settings['layout_three_bg']['url']); ?>">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <div class="sw-landing-download__left">
                        <div class="sw-sec-heading sw-sec-heading__three">
                            <h3 class="sw-sec-heading__title"><?php echo wp_kses($settings['layout_three_sec_title'], 'swiftcart_core_allowed_tags'); ?></h3>
                            <p class="sw-sec-heading__summary"><?php echo wp_kses($settings['layout_three_sec_summary'], 'swiftcart_core_allowed_tags'); ?></p>
                        </div>
                        <?php if (is_array($settings['layout_three_features_list'])) : ?>
                            <div class="sw-landing-download__list">
                                <ul>
                                    <?php foreach ($settings['layout_three_features_list'] as $item) : ?>
                                        <li><?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true'], 'i'); ?><?php echo esc_html($item['title']); ?></li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        <div class="sw-download-btns">
                            <?php if (!empty($settings['playstore_image']['url'])) : ?>
                                <a class="sw-download-btn" <?php esc_attr(!empty($settings['playstore_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['playstore_url']['url']); ?>">

                                    <?php swiftcart_elementor_rendered_image($settings, 'playstore_image'); ?>
                                </a>
                            <?php endif; ?>
                            <?php if (!empty($settings['applestore_image']['url'])) : ?>
                                <a class="sw-download-btn" <?php esc_attr(!empty($settings['applestore_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['applestore_url']['url']); ?>">

                                    <?php swiftcart_elementor_rendered_image($settings, 'applestore_image'); ?>
                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="sw-landing-download__right">
                        <div class="sw-landing-download__img">
                            <?php swiftcart_elementor_rendered_image($settings, 'layout_three_image'); ?>
                        </div>
                        <div class="sw-landing-download__img__two">
                            <?php swiftcart_elementor_rendered_image($settings, 'layout_three_image_two'); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>