<?php if ('layout_two' == $settings['layout_type']) : ?>

    <div class="sw-choose-one pt-80 pb-80">
        <div class="sw-choose-one__bg" data-bg="<?php echo esc_url($settings['layout_two_image']['url']); ?>"></div>
        <div class="container">
            <div class="row gutter-y-30 align-items-center">
                <div class="col-lg-6">
                    <div class="sw-choose-one__left">
                        <h3 class="sw-choose-one__title"><?php echo wp_kses($settings['layout_two_sec_title'], 'swiftcart_core_allowed_tags'); ?></h3>
                        <p class="sw-choose-one__info"><?php echo wp_kses($settings['layout_two_sec_summary'], 'swiftcart_core_allowed_tags'); ?></p>

                        <?php if (is_array($settings['features_list_layout_two'])) : ?>
                            <div class="sw-choose-one__list row gutter-y-30">
                                <?php foreach ($settings['features_list_layout_two'] as $item) : ?>
                                    <div class="col-xl-6">
                                        <div class="sw-choose-one__list-item"><?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true'], 'i'); ?><?php echo esc_html($item['title']); ?></div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <?php if (is_array($settings['feaure_count_list'])) : ?>
                    <div class="col-lg-6">
                        <div class="sw-choose-one__right">
                            <div class="row gutter-y-60">
                                <?php foreach ($settings['feaure_count_list'] as $item) : ?>
                                    <div class="col-sm-6">
                                        <div class="sw-counter-two">
                                            <div class="sw-counter-two__icon">
                                                <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true'], 'i'); ?>
                                            </div>
                                            <h3 class="sw-counter-two__count sw-count-box">
                                                <span class="sw-counter-two__up sw-count-number" data-stop="<?php echo esc_attr($item['count']) ?>" data-speed="1500"></span>
                                            </h3>
                                            <p class="sw-counter-two__title"><?php echo esc_html($item['title']); ?></p>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

<?php endif; ?>