<?php if ('layout_one' == $settings['layout_type']) : ?>
    <div class="sw-footer-one__widget sw-widget-col-1">
        <div class="sw-footer-one__logo">
            <?php if (!empty($settings['logo']['url'])) : ?>
                <a href="<?php echo esc_url(home_url('/')); ?>">
                    <img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_attr($settings['logo']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
                </a>
            <?php endif; ?>
        </div>
        <p class="sw-footer-one__about"><?php echo wp_kses($settings['summary'], 'swiftcart_core_allowed_tags'); ?></p>
        <?php if (is_array($settings['counter'])) : ?>
            <div class="sw-footer-one__cta">
                <?php foreach ($settings['counter'] as $item) : ?>
                    <span><i class="<?php echo esc_attr($item['icon']['value']); ?>"></i><?php echo wp_kses($item['summary'], 'swiftcart_core_allowed_tags'); ?></span>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        <div class="sw-footer-one__social">
            <?php if (is_array($settings['social_icon'])) : ?>
                <?php foreach ($settings['social_icon'] as $item) : ?>
                    <a <?php esc_attr(!empty($item['social_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_attr($item['social_url']['url']); ?>"><i class="<?php echo esc_attr($item['icon']['value']); ?>"></i></a>
                <?php endforeach; ?>
            <?php endif; ?>
        </div>
    </div>

<?php endif; ?>