<?php if ('layout_two' == $settings['layout_type']) : ?>

    <div class="footer-area text-white">
        <div class="widget widget_about">
            <div class="logo_footer mb-25">
                <a href="<?php echo esc_url(home_url('/')); ?>">
                    <?php if ('image' == $settings['logo_type']) : ?>
                        <?php if (!empty($settings['logo']['url'])) : ?>
                            <img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_attr($settings['logo']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
                        <?php endif; ?>
                    <?php else : ?>
                        <?php if (!empty($settings['icon_logo']['value']['url'])) : ?>
                            <img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_url($settings['icon_logo']['value']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
                        <?php endif; ?>
                    <?php endif; ?>
                </a>
            </div>
            <p><?php echo wp_kses($settings['summary'], 'swiftcart_core_allowed_tags'); ?></p>
            <?php if (is_array($settings['counter'])) : ?>
                <div class="footer-counter-wrap">
                    <?php foreach ($settings['counter'] as $item) : ?>
                        <div class="counter-item counter-text-wrap">
                            <div class="counter-item__icon" style="background-image: url(<?php echo esc_url($item['counter_shape']['url']); ?>);"><i class="<?php echo esc_attr($item['icon']['value']); ?>"></i></div>
                            <div class="counter-item__content">
                                <span class="count-text" data-speed="3000" data-stop="<?php echo esc_attr($item['counter_number']); ?>">0</span>
                                <h5 class="counter-title"><?php echo esc_html($item['counter_text']); ?></h5>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>