<?php if ('layout_one' == $settings['layout_type']) : ?>
    <div class="widget widget_newsfeed">
        <h4 class="widget-title"><?php echo esc_html($settings['widget_title']); ?></h4>
        <ul class="footer-blog">
            <?php
            $blog_post_one_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
            $args = array(
                'post_type' => 'post',
                'post_status' => 'publish',
                'ignore_sticky_posts' => true,
                'orderby' => 'date',
                'order'   => $settings['order'],
                'paged'          => $blog_post_one_query_paged,
                'posts_per_page' => $settings['post_count']['size'],
                'paged' => $blog_post_one_query_paged
            );
            $posts_query = new \WP_Query($args);
            ?>
            <?php while ($posts_query->have_posts()) :
                $posts_query->the_post();
                $category =  get_the_terms(get_the_ID(), 'category');
            ?>
                <li>
                    <div class="thumb">
                        <?php the_post_thumbnail('swiftcart_blog_85X85'); ?>
                    </div>
                    <div class="info">
                        <?php $blog_title = get_the_title();
                        $blog_title_count = substr($blog_title, 0, $settings['post_title_count']['size']); ?>
                        <h4 class="footer-blog__title"><a href="<?php the_permalink() ?>"><?php echo $blog_title_count ?></a></h4>
                        <a href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>"><i class="far fa-user"></i><?php echo get_the_author(); ?></a>
                        <span><i class="far fa-calendar-alt"></i><?php echo get_the_date() ?></span>
                    </div>
                </li>
            <?php
            endwhile; ?>
        </ul>
    </div>
<?php endif; ?>