<?php if ('layout_one' == $settings['layout_type']) : ?>
	<div class="footer-top">
		<div class="container">
			<div class="row">
				<div class="col-md-4">
					<?php if (!empty($settings['logo']['url'])) : ?>
						<a href="<?php echo esc_url(home_url('/')); ?>">
							<img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_attr($settings['logo']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
						</a>
					<?php endif; ?>
				</div>
				<div class="col-md-8 text-md-end mt-3 mt-md-0">
					<ul class="social-area">
						<?php if (is_array($settings['social_icon'])) : ?>
							<?php foreach ($settings['social_icon'] as $item) : ?>
								<li>
									<a <?php esc_attr(!empty($item['social_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_attr($item['social_url']['url']); ?>"><i class="<?php echo esc_attr($item['icon']['value']); ?>"></i></a>
								</li>
							<?php endforeach; ?>
						<?php endif; ?>
					</ul>
				</div>
			</div>
		</div>
	</div>
<?php endif; ?>