<?php if ('layout_one' == $settings['layout_type']) : ?>

    <!--======  Start Gallery Section  ======-->
    <section class="gallery-section pt-115 pb-100">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="section-title text-center mb-55 wow fadeInDown">
                        <?php if (!empty($settings['sec_sub_title'])) : ?>
                            <span class="sub-title"><?php swiftcart_elementor_rendered_image($settings, 'subtitle_shape'); ?><?php echo wp_kses($settings['sec_sub_title'], 'swiftcart_core_allowed_tags');  ?><?php swiftcart_elementor_rendered_image($settings, 'subtitle_shape'); ?></span>
                        <?php endif; ?>
                        <?php if (!empty($settings['sec_title'])) : ?>
                            <h2><?php echo wp_kses($settings['sec_title'], 'swiftcart_core_allowed_tags');  ?></h2>
                        <?php endif; ?>
                        <?php if (!empty($settings['sec_summary'])) : ?>
                            <p><?php echo wp_kses($settings['sec_summary'], 'swiftcart_core_allowed_tags');  ?></p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <div class="ac-isotope">
                <?php if ('yes' == $settings['layout_one_enable_filter']) : ?>
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="filter-nav text-center mb-50 wow fadeInUp">
                                <ul class="filter-nav-items">
                                    <li data-filter="*" class="active"><?php esc_html_e('All', 'swiftcart-core'); ?></li>
                                    <?php foreach ($settings['layout_one_projects_filter'] as $item) : ?>
                                        <li data-filter=".<?php echo esc_attr($item['slug']); ?>"><?php echo esc_html($item['name']); ?></li>
                                    <?php endforeach; ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
                <div class="isotope-wrapper row isotope-grid  wow fadeInDown">
                    <?php foreach ($settings['gallery_list_one'] as $index => $item) : ?>
                        <div class="col-lg-3 col-sm-12 isotope-filter-item <?php echo esc_attr($item['slug']); ?>">
                            <div class="gallery-item">
                                <div class="gallery-img  mb-20 swiftcart-tilt" data-tilt-options='{ "glare": false, "maxGlare": 0, "maxTilt": 5, "speed": 700, "scale": 1 }'>
                                    <?php swiftcart_elementor_rendered_image($item, 'image'); ?>
                                </div>
                                <div class="gallery-img  mb-20 swiftcart-tilt" data-tilt-options='{ "glare": false, "maxGlare": 0, "maxTilt": 5, "speed": 700, "scale": 1 }'>
                                    <?php swiftcart_elementor_rendered_image($item, 'image_two'); ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </section><!--======  End Gallery Section  ======-->

<?php endif; ?>