<?php if ('layout_four' == $settings['layout_type']) : ?>
    <header>
        <div class="sw-header-landing sw-transparent-header z-index-11" id="sw-header-sticky">
            <div class="container">
                <div class="sw-header-two__wrapper">
                    <div class="sw-header-two__logo">
                        <a href="<?php echo esc_url(home_url('/')); ?>">
                            <img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_attr($settings['logo']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
                        </a>
                    </div>
                    <div class="sw-header-two__right">
                        <div class="sw-header-one__menu sw-main-menu">
                            <nav id="mobile-menu">
                                <?php
                                wp_nav_menu(
                                    array(
                                        'menu' => $settings['nav_menu'],
                                        'menu_class' => 'ul-0',
                                        'container' => ''
                                    )
                                );
                                ?>
                            </nav>
                        </div>
                        <div class="sw-header-two__btns d-none d-lg-flex">
                            <div class="sw-header-landing-btn">
                                <?php if (!empty($settings['button_label'])) : ?>
                                    <a class="swiftcart-btn" <?php esc_attr(!empty($settings['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['button_url']['url']); ?>"><?php echo esc_html($settings['button_label']); ?> <i class="icon-log-in"></i></a>
                                <?php endif; ?>
                            </div>
                            <div class="sw-header-two__hamburger d-xl-none">
                                <button type="button" class="sw-offcanvas-btn sw-header-two__btn">
                                    <i class="icon-menu"></i>Nav Bar
                                </button>
                            </div>
                        </div>
                    </div>
                    <!-- mobile drawer  -->
                    <div class="sw-header-two__hamburger d-lg-none">
                        <button type="button" class="sw-offcanvas-btn sw-header-two__btn">
                            <i class="icon-menu"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </header>
<?php endif; ?>