<?php if ('layout_one' == $settings['layout_type']) : ?>
    <header>
        <div class="sw-header-one bg-black" id="sw-header-sticky">
            <div class="container">
                <div class="sw-header-one__wrapper">
                    <div class="sw-header-one__logo">
                        <a href="<?php echo esc_url(home_url('/')); ?>">
                            <img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_attr($settings['logo']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
                        </a>
                    </div>
                    <div class="sw-header-one__right">
                        <div class="sw-header-one__search d-none d-xl-block">
                            <?php echo do_shortcode('[product_search_form]'); ?>
                        </div>
                        <div class="sw-header-one__btns d-none d-lg-flex">
                            <?php if (is_array($settings['header_btns'])) : ?>
                                <?php foreach ($settings['header_btns'] as $item) : ?>
                                    <a <?php esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>" class="sw-header-one__btn">
                                        <i class="<?php echo esc_attr($item['icon']['value']); ?>"></i><?php echo esc_html($item['title']); ?>
                                    </a>
                                <?php endforeach; ?>
                            <?php endif; ?>
                            <?php if (class_exists('woocommerce')):
                                global $woocommerce;
                                if (! empty($woocommerce->cart->cart_contents_count)) {
                                    $count = $woocommerce->cart->cart_contents_count;
                                } else {
                                    $count = "0";
                                }
                            ?>
                                <a href="<?php echo wc_get_cart_url(); ?>" class="sw-header-one__btn">
                                    <i class=" icon-grocery-store"></i>
                                    <?php echo esc_html__("My Cart", 'swiftcart-core'); ?>
                                    <span class="badge cart-count"><?php echo esc_html($count); ?></span>
                                </a>
                            <?php endif; ?>
                            <!-- mobile drawer  -->
                            <div class="sw-header-one__hamburger d-xl-none">
                                <button type="button" class="sw-offcanvas-btn sw-header-one__btn"><i class="icon-menu"></i><?php echo esc_html__('Nav Bar', 'swiftcart-core'); ?></button>
                            </div>
                        </div>
                    </div>
                    <!-- mobile drawer  -->
                    <div class="sw-header-one__hamburger d-lg-none">
                        <button type="button" class="sw-offcanvas-btn sw-header-one__btn">
                            <i class="icon-menu"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        <div class="sw-header-one__bottom d-none d-lg-block">
            <div class="container">
                <div class="sw-header-one__bottom-wrapper">
                    <div class="sw-header-one__bottom-left">
                        <div class="sw-header-one__cat">
                            <i class="icon-menu"></i>
                            <span class="sw-header-one__cat-text"><?php echo esc_html__('All Category', 'swiftcart-core'); ?></span>
                            <div class="sw-header-one__cat-list">
                                <?php
                                wp_nav_menu(
                                    array(
                                        'menu' => $settings['cat_menu'],
                                        'menu_class' => '',
                                        'container' => ''
                                    )
                                );
                                ?>
                            </div>
                        </div>
                        <div class="sw-header-one__menu sw-main-menu">
                            <nav id="mobile-menu">
                                <?php
                                $menu_id = $settings['nav_menu'];
                                $main_slider_menu = get_term_by('name', 'Main Slider', 'nav_menu');

                                if ($menu_id == '16' && $main_slider_menu && $main_slider_menu->term_id != '16') {
                                    $menu_id = $main_slider_menu->term_id;
                                }

                                wp_nav_menu(
                                    array(
                                        'menu' => $menu_id,
                                        'menu_class' => 'ul-0',
                                        'container' => ''
                                    )
                                );
                                ?>
                            </nav>
                        </div>
                    </div>
                    <div class="sw-header-one__bottom-right">
                        <?php if (function_exists('Yay_Currency\\plugin_init')): ?>
                            <div class="sw-header-one__currency">
                                <?php echo do_shortcode('[yaycurrency-switcher]'); ?>
                            </div>
                        <?php endif; ?>
                        <?php if (class_exists('GTranslate')): ?>
                            <div class="sw-header-one__lang">
                                <?php echo do_shortcode('[gtranslate]'); ?>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </header>
<?php endif; ?>