<?php if ('layout_three' == $settings['layout_type']) : ?>
    <header>
        <div class="sw-header-two__top sw-header-three__top d-none d-lg-block">
            <div class="container">
                <div class="sw-header-two__top-wrapper d-flex justify-content-between">
                    <div class="sw-header-two__top-left">
                        <p><?php echo esc_html($settings['note']); ?></p>
                    </div>
                    <div class="sw-header-two__bottom-right">
                        <div class="sw-header-two__cta">
                            <?php foreach ($settings['header_btns'] as $item) : ?>
                                <a <?php esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>">
                                    <i class="<?php echo esc_attr($item['icon']['value']); ?>"></i><?php echo esc_html($item['title']); ?>
                                </a>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="sw-header-two sw-header-three" id="sw-header-sticky">
            <div class="container">
                <div class="sw-header-two__wrapper">
                    <div class="sw-header-two__logo">
                        <a href="<?php echo esc_url(home_url('/')); ?>">
                            <img width="<?php echo esc_attr($settings['logo_dimension']['width']); ?>" height="<?php echo esc_attr($settings['logo_dimension']['height']); ?>" src="<?php echo esc_attr($settings['logo']['url']); ?>" alt="<?php echo esc_attr(get_bloginfo('name')); ?>">
                        </a>
                    </div>
                    <div class="sw-header-two__right">
                        <div class="sw-header-one__menu sw-main-menu">
                            <nav id="mobile-menu">
                                <?php
                                $menu_id = $settings['nav_menu'];
                                $main_slider_menu = get_term_by('name', 'Main Slider', 'nav_menu');

                                if ($menu_id == '16' && $main_slider_menu && $main_slider_menu->term_id != '16') {
                                    $menu_id = $main_slider_menu->term_id;
                                }

                                wp_nav_menu(
                                    array(
                                        'menu' => $menu_id,
                                        'menu_class' => 'ul-0',
                                        'container' => ''
                                    )
                                );
                                ?>
                            </nav>
                        </div>
                        <div class="sw-header-two__btns d-none d-lg-flex">
                            <?php if (class_exists('woocommerce')):
                                global $woocommerce;
                                if (! empty($woocommerce->cart->cart_contents_count)) {
                                    $count = $woocommerce->cart->cart_contents_count;
                                } else {
                                    $count = "0";
                                }
                            ?>
                                <a href="<?php echo wc_get_cart_url(); ?>" class="sw-header-two__btn">
                                    <i class="icon-shopping-cart"></i>
                                    <span class="badge cart-count"><?php echo esc_html($count); ?></span>
                                </a>
                            <?php endif; ?>
                            <?php if ('yes' == $settings['whish_list']) : ?>
                                <a href="<?php echo esc_url($settings['whish_url']['url']);  ?>" class="sw-header-two__btn">
                                    <i class="icon-love"></i>
                                </a>
                            <?php endif; ?>
                            <?php if ('yes' == $settings['user_status']) : ?>
                                <a href="<?php echo esc_url($settings['login_url']['url']);  ?>" class="sw-header-two__btn">
                                    <i class="icon-user-1"></i>
                                </a>
                            <?php endif; ?>
                            <!-- mobile drawer  -->
                            <div class="sw-header-two__hamburger d-xl-none">
                                <button type="button" class="sw-offcanvas-btn sw-header-two__btn">
                                    <i class="icon-menu"></i><?php echo esc_html__('Nav Bar', 'swiftcart-core'); ?>
                                </button>
                            </div>
                        </div>
                    </div>
                    <!-- mobile drawer  -->
                    <div class="sw-header-two__hamburger d-lg-none">
                        <button type="button" class="sw-offcanvas-btn sw-header-two__btn">
                            <i class="icon-menu"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </header>
<?php endif; ?>