<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!-- feature two start -->
    <div class="sw-feature-two pt-80 pb-80">
        <div class="container">
            <div class="row gutter-y-30">
                <?php foreach ($settings['infobox'] as $index => $item) : ?>
                    <div class="col-xl-3 col-md-6">
                        <div class="sw-feature-two__item">
                            <?php if (!empty($item['icon'])): ?>
                                <div class="sw-feature-two__icon" data-bg-color="<?php echo esc_attr($item['bg_color']) ?>">
                                    <span><?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true'], 'i'); ?></span>
                                </div>
                            <?php endif; ?>
                            <?php if (!empty($item['title'])): ?>
                                <h3 class="sw-feature-two__title"><?php echo esc_html($item['title']); ?></h3>
                            <?php endif; ?>
                            <?php if (!empty($item['content'])): ?>
                                <p class="sw-feature-two__info"><?php echo wp_kses($item['content'], 'swiftcart_core_allowed_tags');  ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
    <!-- feature two end -->
<?php endif; ?>