<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!-- feature one start -->
    <div class="sw-features-one">
        <div class="container">
            <div class="row gutter-y-30">
                <?php foreach ($settings['infobox'] as $index => $item) : ?>
                    <div class="col-xl-3 col-md-6">
                        <div class="sw-feature-one__item">
                            <?php if (!empty($item['icon'])): ?>
                                <div class="sw-feature-one__icon">
                                    <?php \Elementor\Icons_Manager::render_icon($item['icon'], ['aria-hidden' => 'true'], 'i'); ?>
                                </div>
                            <?php endif; ?>
                            <div class="sw-feature-one__content">
                                <?php if (!empty($item['title'])): ?>
                                    <h3 class="sw-feature-one__title"><?php echo esc_html($item['title']); ?></h3>
                                <?php endif; ?>
                                <?php if (!empty($item['content'])): ?>
                                    <p class="sw-feature-one__info"><?php echo wp_kses($item['content'], 'swiftcart_core_allowed_tags');  ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
    <!-- feature one end -->


<?php endif; ?>