<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!-- offer one start -->
    <div class="sw-offer-one pb-80">
        <div class="container">
            <div class="sw-offer-one__wrap bg-white">
                <div class="row align-items-md-center">
                    <div class="col-xl-4">
                        <div class="sw-offer-one__timer">
                            <?php if (!empty($settings['title'])): ?>
                                <h3 class="sw-offer-one__title"><?php echo esc_html($settings['title']) ?></h3>
                            <?php endif; ?>
                            <?php if (!empty($settings['info'])): ?>
                                <p class="sw-oofer-one__info"><?php echo esc_html($settings['info']) ?></p>
                            <?php endif; ?>
                            <div class="sw-offer-one__countdown" data-countdown data-date="<?php echo esc_attr($settings['date']); ?>">
                                <div class="sw-offer-one__countdown-inner">
                                    <ul>
                                        <li><span data-days><?php esc_html_e("Days", 'swiftcart-core'); ?></span><?php esc_html_e("Days", 'swiftcart-core'); ?></li>
                                        <li><span data-hours><?php esc_html_e("Days", 'swiftcart-core'); ?></span><?php esc_html_e("Hrs", 'swiftcart-core'); ?></li>
                                        <li><span data-minutes><?php esc_html_e("Days", 'swiftcart-core'); ?></span><?php esc_html_e("Min", 'swiftcart-core'); ?></li>
                                        <li><span data-seconds><?php esc_html_e("Days", 'swiftcart-core'); ?></span><?php esc_html_e("Sec", 'swiftcart-core'); ?> </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-8">
                        <div class="sw-offer-one__cats">
                            <div class="row row-cols-lg-5">
                                <?php foreach ($settings['offerlist'] as $index => $item) : ?>
                                    <div class="col">
                                        <div class="sw-offer-one__cat">
                                            <?php swiftcart_elementor_rendered_image($item, 'image'); ?>
                                            <?php if (!empty($item['category'])): ?>
                                                <h4 class="sw-offer-one__cat-title"><a href="<?php echo esc_url($item['url']['url']);?>"><?php echo esc_html($item['category']) ?></a></h4>
                                            <?php endif; ?>
                                            <?php if (!empty($item['offers'])): ?>
                                                <span class="sw-offer-one__cat-count"><?php echo esc_html($item['offers']) ?></span>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- offer one end -->
<?php endif; ?>