<?php if ('layout_two' == $settings['layout_type']) : ?>
    <!-- countdown start -->
    <div class="sw-ads-countdown grey-bg-2">
        <div class="sw-ads-countdown__shape-2">
            <?php swiftcart_elementor_rendered_image($settings, 'shape'); ?>
        </div>
        <div class="container">
            <div class="row align-items-center gutter-y-30">
                <div class="col-lg-6">
                    <div class="sw-ads-countdown__img w-img">
                        <?php swiftcart_elementor_rendered_image($settings, 'image'); ?>
                        <div class="sw-ads-countdown__shape">
                            <?php swiftcart_elementor_rendered_image($settings, 'border_shape'); ?>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="sw-ads-countdown__content">
                        <?php if (!empty($settings['subtitle'])): ?>
                            <span class="sw-ads-countdown__subtitle"><?php echo esc_html($settings['subtitle']) ?></span>
                        <?php endif; ?>
                        <?php if (!empty($settings['title'])): ?>
                            <h3 class="sw-ads-countdown__title"><?php echo wp_kses($settings['title'], 'swiftcart_core_allowed_tags'); ?></h3>
                        <?php endif; ?>
                        <?php if (!empty($settings['info'])): ?>
                            <p class="sw-ads-countdown__info"><?php echo wp_kses($settings['info'], 'swiftcart_core_allowed_tags') ?></p>
                        <?php endif; ?>
                        <div class="sw-ads-countdown__count" data-countdown data-date="<?php echo esc_attr($settings['date']); ?>">
                            <div class="sw-ads-countdown__count-inner">
                                <!-- <p>Deals ends in</p> -->
                                <ul>
                                    <li><span data-days><?php esc_html_e("Days", 'swiftcart-core'); ?></span><?php esc_html_e("Days", 'swiftcart-core'); ?></li>
                                    <li><span data-hours><?php esc_html_e("Hrs", 'swiftcart-core'); ?></span><?php esc_html_e("Hrs", 'swiftcart-core'); ?></li>
                                    <li><span data-minutes><?php esc_html_e("Min", 'swiftcart-core'); ?></span><?php esc_html_e("Min", 'swiftcart-core'); ?></li>
                                    <li><span data-seconds><?php esc_html_e("Sec", 'swiftcart-core'); ?></span><?php esc_html_e("Sec", 'swiftcart-core'); ?> </li>
                                </ul>
                            </div>
                        </div>
                        <?php if (!empty($settings['button_label'])) : ?>
                            <div class="sw-ads-countdown__btn">
                                <a class="swiftcart-btn-black swiftcart-btn-black-large" <?php esc_attr(!empty($settings['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['button_url']['url']); ?>"><?php echo esc_html($settings['button_label']); ?></a>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- countdown end -->
<?php endif; ?>