<?php if ('layout_one' == $settings['layout_type']) : ?>

    <div class="become-volunteer-video-area pb-65">
        <div class="container">
            <div class="row">
                <div class="col-xl-5">
                    <div class="become-volunteer-video-content mb-45">
                        <ul class="list-style-two">
                            <?php if (is_array($settings['details_left_list'])) : ?>
                                <?php foreach ($settings['details_left_list'] as $item) : ?>
                                    <li><?php echo esc_html($item['title']) ?></li>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </ul>
                        <p><?php echo esc_html($settings['summary']) ?></p>
                        <br>
                        <h6><?php echo esc_html($settings['tag_title']) ?></h6>
                        <div class="tags mb-20">
                            <p><?php echo esc_html($settings['tag']) ?></p>
                        </div>
                        <ul class="earning-doner">
                            <?php if (is_array($settings['donar_list'])) : ?>
                                <?php foreach ($settings['donar_list'] as $item) : ?>
                                    <li>
                                        <span><?php echo esc_html($item['title']) ?></span>
                                        <b><?php echo esc_html($item['doantion']) ?></b>
                                    </li>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
                <div class="col-xl-7">
                    <div class="become-volunteer-video overlay mb-55">
                        <img src="<?php echo esc_html($settings['video_thumb']['url']) ?>" alt="<?php echo esc_attr(swiftcart_core_get_thumbnail_alt($settings['video_thumb']['id'])); ?>">
                        <a class="video-play video-play--four" href="<?php echo esc_html($settings['video_url']['url']) ?>" data-effect="mfp-zoom-in"><i class="fa fa-play"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php endif; ?>