<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!-- Portfolio Area start -->
    <div class="portfolio-page-area pt-120 pb-90 rel z-1">
        <div class="container">
            <ul class="portfolio-filter pb-35">
                <li data-filter="*" class="current"><?php echo esc_html__("All", 'swiftcart-core') ?></li>
                <?php if (is_array($settings['portfolio_button'])) : ?>
                    <?php foreach ($settings['portfolio_button'] as $item) : ?>
                        <li data-filter=".<?php echo esc_attr($item['slug']) ?>">
                            <?php echo esc_html($item['button_label']) ?></li>
                    <?php endforeach ?>
                <?php endif; ?>
            </ul>
            <div class="row portfolio-active justify-content-center">
                <?php if (is_array($settings['portfolio_list'])) : ?>
                    <?php foreach ($settings['portfolio_list'] as $item) : ?>
                        <div class="col-xl-4 col-md-6 item <?php echo esc_attr($item['slugs']) ?>">
                            <div class="portfolio-item">
                                <img src="<?php echo esc_attr($item['thumb']['url']); ?>" alt="<?php echo esc_attr(swiftcart_core_get_thumbnail_alt($item['thumb']['id'])); ?>">
                                <div class="portfolio-item__over">
                                    <a class="details-btn" href="<?php echo esc_url($item['url']['url']) ?>"><i class="<?php echo esc_attr($item['icon']['value']); ?>"></i></a>
                                    <h5><a href="<?php echo esc_url($item['url']['url']) ?>"><?php echo esc_html($item['title']); ?></a></h5>
                                    <span class="category"><?php echo esc_html($item['tagline']); ?></span>
                                </div>
                            </div>
                        </div>
                    <?php endforeach ?>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <!-- Portfolio Area end -->

<?php endif; ?>