<?php if ('layout_three' == $settings['layout_type']) : ?>
    <!--======  Start Pricing Section  ======-->
    <section class="pricing-section">
        <div class="pricing-bg-wrapper bg_cover pt-125 pb-80" style="background-image: url(<?php echo esc_url($settings['layout_three_background_image']['url']) ?>);">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <!--===  Section Title  ===-->
                        <div class="section-title text-center text-white mb-50 wow fadeInDown">
                            <?php if (!empty($settings['layout_three_sec_sub_title'])) : ?>
                                <span class="sub-title"><?php swiftcart_elementor_rendered_image($settings, 'layout_three_subtitle_shape'); ?><?php echo wp_kses($settings['layout_three_sec_sub_title'], 'swiftcart_core_allowed_tags');  ?><?php swiftcart_elementor_rendered_image($settings, 'layout_three_subtitle_shape'); ?></span>
                            <?php endif; ?>
                            <?php if (!empty($settings['layout_three_sec_title'])) : ?>
                                <h2><?php echo wp_kses($settings['layout_three_sec_title'], 'swiftcart_core_allowed_tags');  ?></h2>
                            <?php endif; ?>
                            <?php if (!empty($settings['layout_three_sec_summary'])) : ?>
                                <p><?php echo wp_kses($settings['layout_three_sec_summary'], 'swiftcart_core_allowed_tags');  ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <?php foreach ($settings['layout_three_pricing_list'] as $index => $item) :  ?>
                        <div class="col-xl-3 col-md-6 col-sm-12">
                            <!--===  Pricing Item  ===-->
                            <div class="pricing-item style-two mb-40 wow fadeInUp">
                                <div class="pricing-head text-center">
                                    <span class="package"><?php echo wp_kses($item['plan_title'], 'swiftcart_core_allowed_tags'); ?></span>
                                    <h3><span class="currency"><?php echo wp_kses($item['price'], 'swiftcart_core_allowed_tags'); ?></span></h3>
                                </div>
                                <div class="pricing-body">
                                    <ul class="check-list style-one ml-0">
                                        <?php echo wp_kses($item['service_list'], 'swiftcart_core_allowed_tags'); ?>
                                    </ul>
                                    <?php if (!empty($item['button_label'])) : ?>
                                        <div class="pricing-button text-center mt-35">
                                            <a href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? "target=_blank" : ' '); ?> class="theme-btn style-two">
                                                <?php echo esc_html($item['button_label']); ?>
                                            </a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </section><!--======  End Pricing Section  ======-->
<?php endif; ?>