<?php if ('layout_two' == $settings['layout_type']) : ?>
    <!--======  Start pricing Section  ======-->
    <section class="pricing-section">
        <div class="pricing-bg-wrapper bg_cover pt-115 pb-80" style="background-image: url(<?php echo esc_url($settings['background_image']['url']) ?>);">
            <div class="container">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="section-title text-white text-center mb-55 wow fadeInDown">
                            <?php if (!empty($settings['sec_sub_title'])) : ?>
                                <span class="sub-title"><?php swiftcart_elementor_rendered_image($settings, 'subtitle_shape'); ?><?php echo wp_kses($settings['sec_sub_title'], 'swiftcart_core_allowed_tags');  ?><?php swiftcart_elementor_rendered_image($settings, 'subtitle_shape'); ?></span>
                            <?php endif; ?>
                            <?php if (!empty($settings['sec_title'])) : ?>
                                <h2><?php echo wp_kses($settings['sec_title'], 'swiftcart_core_allowed_tags');  ?></h2>
                            <?php endif; ?>
                            <?php if (!empty($settings['sec_summary'])) : ?>
                                <p><?php echo wp_kses($settings['sec_summary'], 'swiftcart_core_allowed_tags');  ?></p>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="pricing-tabs style-one text-center mb-40 wow fadeInUp">
                            <ul class="nav nav-tabs">
                                <li>
                                    <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#monthly"><?php echo wp_kses($settings['monthly_heading'], 'swiftcart_core_allowed_tags'); ?></button>
                                </li>
                                <li>
                                    <button class="nav-link" data-bs-toggle="tab" data-bs-target="#annual"><?php echo wp_kses($settings['yearly_heading'], 'swiftcart_core_allowed_tags'); ?></button>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-12">
                        <div class="tab-content wow fadeInDown">
                            <div class="tab-pane fade show active" id="monthly">
                                <div class="row">
                                    <?php foreach ($settings['pricing_monthly_list'] as $index => $item) :  ?>
                                        <div class="col-xl-3 col-md-6 col-sm-12">
                                            <div class="pricing-item style-three mb-40 wow fadeInUp">
                                                <div class="pricing-head text-center">
                                                    <span class="package"><?php echo wp_kses($item['plan_title'], 'swiftcart_core_allowed_tags'); ?></span>
                                                    <h3><span class="currency"><?php echo wp_kses($item['price'], 'swiftcart_core_allowed_tags'); ?></span></h3>
                                                </div>
                                                <div class="pricing-body">
                                                    <ul class="check-list style-one">
                                                        <?php echo wp_kses($item['service_list'], 'swiftcart_core_allowed_tags'); ?>
                                                    </ul>
                                                </div>
                                                <?php if (!empty($item['button_label'])) : ?>
                                                    <div class="pricing-button text-center">
                                                        <a href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? "target=_blank" : ' '); ?> class="theme-btn style-two">
                                                            <?php echo esc_html($item['button_label']); ?>
                                                        </a>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="annual">
                                <div class="row">
                                    <?php foreach ($settings['pricing_yearly_list'] as $index => $item) :  ?>
                                        <div class="col-xl-3 col-md-6 col-sm-12">
                                            <div class="pricing-item style-three mb-40 wow fadeInUp">
                                                <div class="pricing-head text-center">
                                                    <span class="package"><?php echo wp_kses($item['plan_title'], 'swiftcart_core_allowed_tags'); ?></span>
                                                    <h3><span class="currency"><?php echo wp_kses($item['price'], 'swiftcart_core_allowed_tags'); ?></span></h3>
                                                </div>
                                                <div class="pricing-body">
                                                    <ul class="check-list style-one">
                                                        <?php echo wp_kses($item['service_list'], 'swiftcart_core_allowed_tags'); ?>
                                                    </ul>
                                                </div>
                                                <?php if (!empty($item['button_label'])) : ?>
                                                    <div class="pricing-button text-center">
                                                        <a href="<?php echo esc_url($item['url']['url']); ?>" <?php esc_attr(!empty($item['url']['is_external']) ? "target=_blank" : ' '); ?> class="theme-btn style-two">
                                                            <?php echo esc_html($item['button_label']); ?>
                                                        </a>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section><!--======  End pricing Section  ======-->
<?php endif; ?>