<?php if ('layout_one' == $settings['layout_type']) : ?>
    <!--======  Start Work Process Section  ======-->
    <section class="works-process-section pb-75">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <!--=== Section Title ===-->
                    <div class="section-title text-center mb-55 wow fadeInDown">
                        <?php
                        if (!empty($settings['sec_sub_title'])) :
                            $this->add_inline_editing_attributes('sec_sub_title', 'none');
                            swiftcart_elementor_rendered_content($this, 'sec_sub_title', 'sub-title style-one', $settings['section_sub_title_tag_layout_one']);
                        endif;

                        if (!empty($settings['sec_title'])) :
                            $this->add_inline_editing_attributes('sec_title', 'none');
                            swiftcart_elementor_rendered_content($this, 'sec_title', '', $settings['section_title_tag_layout_one']);
                        endif;

                        if (!empty($settings['sec_summary'])) :
                            $this->add_inline_editing_attributes('sec_summary', 'none');
                            swiftcart_elementor_rendered_content($this, 'sec_summary', '', 'p');
                        endif;
                        ?>
                    </div>
                </div>
            </div>
            <div class="row justify-content-center">
                <?php if (is_array($settings['items'])) : ?>
                    <?php foreach ($settings['items'] as $item) : ?>
                        <div class="col-xl-4 col-md-6 col-sm-6">
                            <!--=== Process Item ===-->
                            <div class="ac-process-item mb-40 wow fadeInUp">
                                <div class="process-inner-content">
                                    <div class="thumbnail swiftcart-tilt" data-tilt-options='{ "glare": false, "maxGlare": 0, "maxTilt": 5, "speed": 700, "scale": 1 }'>
                                        <?php swiftcart_elementor_rendered_image($item, 'image'); ?>
                                    </div>
                                    <div class="content">
                                        <span class="number"><?php echo esc_html($item['number']); ?></span>
                                        <h5><?php echo esc_html($item['title']); ?></h5>
                                        <p><?php echo esc_html($item['text']); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </section><!--======  End Work Process Section  ======-->
<?php endif; ?>