<?php if ('layout_one' == $settings['layout_type']) : ?>

    <!-- product cat one start -->
    <div class="sw-category-one pb-80">
        <div class="container">

            <div class="sw-category-slider__carousel swiftcart-owl__carousel owl-carousel" data-owl-options='<?php echo esc_attr(swiftcart_core_get_owl_options($settings)); ?>'>

                <?php  // Loop through the selected categories
                // Get the selected categories from the Elementor control
                $categories = swiftcart_core_taxonomy_list('product_cat');
                $selected_categories = $settings['category_list'] ? $settings['category_list'] : $categories;
                foreach ($selected_categories as $category_slug) :
                    $category = get_term_by('slug', $category_slug, 'product_cat');
                    $thumbnail_id = get_term_meta($category->term_id, 'thumbnail_id', true);
                    $thumbnail_url = wp_get_attachment_url($thumbnail_id);
                    $category_link = get_term_link($category->slug, 'product_cat');
                    $category_name = $category->name;
                    $category_product_cout = $category->count;

                ?>
                    <?php if ($settings['show_empty_category'] == 'yes' || $category_product_cout !== 0): ?>
                        <div class="sw-category-one__item">
                            <?php if (!empty($thumbnail_url)): ?>
                                <div class="sw-category-one__img">
                                    <img src="<?php echo esc_url($thumbnail_url); ?>" alt="<?php echo esc_attr($category_name) ?>">
                                </div>
                            <?php endif; ?>

                            <h3 class="sw-category-one__title el-cat-name">
                                <a href="<?php echo esc_url($category_link); ?>">
                                    <?php echo esc_html($category_name); ?>
                                    <?php if ($settings['product_count'] == 'yes'): ?>
                                        (<?php echo $category_product_cout ?>)
                                    <?php endif; ?>
                                </a>
                            </h3>
                        </div>
                <?php endif; ?>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
    <!-- product cat one end -->

<?php endif; ?>