<?php if ('layout_two' == $settings['layout_type']) : ?>
    <!-- category two start  -->
    <div class="sw-cats-two pb-80">
        <div class="container">
            <div class="row g-0">
                <div class="col-lg-3">
                    <div class="sw-cats-two__ads w-img">
                        <?php swiftcart_elementor_rendered_image($settings, 'image'); ?>
                    </div>
                </div>
                <?php if (is_array($settings['features_list'])) : ?>
                    <div class="col-lg-9">
                        <div class="sw-cats-two__wrapper">
                            <div class="row g-0">
                                <?php foreach ($settings['features_list'] as $item) : ?>
                                    <div class="col-md-6 col-lg-3">
                                        <div class="sw-cats-two__item">
                                            <h3 class="sw-cats-two__title">
                                                <a <?php esc_attr(!empty($item['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($item['url']['url']); ?>"><?php echo esc_html($item['title']); ?></a>
                                            </h3>
                                            <p class="sw-cats-two__info"><?php echo wp_kses($item['info'], 'swiftcart_core_allowed_tags'); ?></p>
                                            <div class="sw-cats-two__img">
                                                <?php swiftcart_elementor_rendered_image($item, 'image'); ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <!-- category two end -->
<?php endif; ?>