<?php if ('layout_eight' == $settings['layout_type']) : ?>
    <!--  best deal start -->
    <div class="sw-best-deal pb-80">
        <div class="container">
            <div class="sw-best-deal__filter-box">
                <div class="row gutter-y-30">
                    <?php if ('yes' == $settings['banner_status']): ?>
                        <div class="col-lg-3">
                            <div class="sw-best-deal__banner sw-best-deal__banner_modify bg-black">
                                <?php if (!empty($settings['title'])) : ?>
                                    <p class="sw-best-deal__banner-title"><?php echo wp_kses($settings['title'], 'swiftcart_core_allowed_tags');  ?></p>
                                <?php endif; ?>
                                <?php swiftcart_elementor_rendered_image($settings, 'banner_image'); ?>
                                <?php if (!empty($settings['button_label'])) : ?>
                                    <a class="swiftcart-btn" <?php esc_attr(!empty($settings['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['button_url']['url']); ?>"><?php echo esc_html($settings['button_label']); ?> <i class="icon-next"></i></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="<?php echo esc_attr($settings['banner_status'] ? 'col-lg-9' : 'col-xl-12'); ?>">
                        <div class="row g-3">
                            <?php
                            $product_post_one_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

                            $args  = array(
                                'post_type'           => 'product',
                                'post_status'         => 'publish',
                                'ignore_sticky_posts' => 1,
                                'posts_per_page'      => $settings['post_count']['size'],
                                'paged' => $product_post_one_query_paged
                            );

                            // $args['orderby'] = $settings['orderby'];
                            // $args['order']   = $settings['order'];
                            if (!empty($settings['exclude_cat'])) {
                                $args['category__not_in'] = $settings['exclude_cat'];
                            }


                            if (!empty($settings['select_cat'])) {
                                $args['tax_query'][] = array(
                                    'taxonomy' => 'product_cat',
                                    'field'    => 'slug',
                                    'terms'    => array_values($settings['select_cat'])
                                );
                            }

                            if (!empty($settings['select_tag'])) {
                                $args['tax_query'][] = array(
                                    'taxonomy' => 'product_tag',
                                    'field'    => 'slug',
                                    'terms'    => array_values($settings['select_tag'])
                                );
                            }
                            if (!empty($settings['product_type'])) {
                                if ($settings['product_type'] == 'top-rated') {
                                    $args['meta_key'] = '_wc_average_rating';
                                    $args['order'] = 'DESC';
                                    $args['orderby'] = 'meta_value_num';
                                } elseif ($settings['product_type'] == 'featured') {
                                    $args['order'] = 'DESC';
                                    $args['orderby'] = 'date';
                                    $args['post__in'] = wc_get_featured_product_ids();
                                } elseif ($settings['product_type'] == 'on-sale') {
                                    $args['post__in'] = wc_get_product_ids_on_sale();
                                    $args['order'] = 'ASC';
                                    $args['orderby'] = 'title';
                                } elseif ($settings['product_type'] == 'best-selling') {
                                    $args['meta_key'] = 'total_sales';
                                    $args['order'] = 'DESC';
                                    $args['orderby'] = 'meta_value_num';
                                } elseif ($settings['product_type'] == 'recent-items') {
                                    $args['order'] = 'DESC';
                                    $args['orderby'] = 'date';
                                }
                            }

                            $product_query = new \WP_Query($args);
                            ?>
                            <?php while ($product_query->have_posts()) :
                                $product_query->the_post();
                                global $product;
                                $regular_price = (float) $product->get_regular_price();
                                $sale_price    = (float) $product->get_sale_price();
                                $price    = (float) $product->get_price_html();
                                $percentage = '';
                                if ($sale_price != 0 || ! empty($sale_price)) {
                                    $percentage    = round(100 - ($sale_price / $regular_price * 100)) . '%';
                                }
                                $product_title_count = substr(get_the_title(), 0, $settings['post_title_count']['size']);
                            ?>
                                <div class="col-md-6 col-lg-4 col-xl-3">
                                    <div class="sw-product-six__item sw-product-six-modify__item">
                                        <?php if (!empty($percentage)): ?>
                                            <span class="sw-product-six__offer"><?php echo esc_html__($percentage, 'swiftcart-core'); ?></span>
                                        <?php endif; ?>
                                        <?php if (has_post_thumbnail()): ?>
                                            <div class="sw-product-six__img">
                                                <?php the_post_thumbnail('swiftcart_product_100x110'); ?>
                                            </div>
                                        <?php endif; ?>
                                        <h5 class="sw-product-six__price el-pd-price"><?php echo woocommerce_template_loop_price(); ?></h5>
                                        <h3 class="sw-product-six__title el-pd-title"><a href="<?php the_permalink(); ?>"><?php echo wp_kses_post($product_title_count); ?></a></h3>
                                        <div class="sw-product-six__ratting el-pd-ratting">
                                            <?php echo swiftcart_woo_rating(); ?>
                                        </div>
                                    </div>
                                </div>
                            <?php endwhile; ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--  best deal end -->

<?php endif; ?>