<?php if ('layout_one' == $settings['layout_type']) : ?>
    <div class="sw-product-list__wrapper">
        <?php if ('yes' == $settings['heading_status']) : ?>
            <?php if (!empty($settings['title'])) : ?>
                <h3 class="sw-product-list__heading el-sec-title"><?php echo wp_kses($settings['title'], 'swiftcart_core_allowed_tags');  ?></h3>
            <?php endif; ?>
        <?php endif; ?>

        <?php
        $product_post_one_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

        $args  = array(
            'post_type'           => 'product',
            'post_status'         => 'publish',
            'ignore_sticky_posts' => 1,
            'posts_per_page'      => $settings['post_count']['size'],
            'paged' => $product_post_one_query_paged
        );

        // $args['orderby'] = $settings['orderby'];
        // $args['order']   = $settings['order'];
        if (!empty($settings['exclude_cat'])) {
            $args['category__not_in'] = $settings['exclude_cat'];
        }


        if (!empty($settings['select_cat'])) {
            $args['tax_query'][] = array(
                'taxonomy' => 'product_cat',
                'field'    => 'slug',
                'terms'    => array_values($settings['select_cat'])
            );
        }

        if (!empty($settings['select_tag'])) {
            $args['tax_query'][] = array(
                'taxonomy' => 'product_tag',
                'field'    => 'slug',
                'terms'    => array_values($settings['select_tag'])
            );
        }
        if (!empty($settings['product_type'])) {
            if ($settings['product_type'] == 'top-rated') {
                $args['meta_key'] = '_wc_average_rating';
                $args['order'] = 'DESC';
                $args['orderby'] = 'meta_value_num';
            } elseif ($settings['product_type'] == 'featured') {
                $args['order'] = 'DESC';
                $args['orderby'] = 'date';
                $args['post__in'] = wc_get_featured_product_ids();
            } elseif ($settings['product_type'] == 'on-sale') {
                $args['post__in'] = wc_get_product_ids_on_sale();
                $args['order'] = 'ASC';
                $args['orderby'] = 'title';
            } elseif ($settings['product_type'] == 'best-selling') {
                $args['meta_key'] = 'total_sales';
                $args['order'] = 'DESC';
                $args['orderby'] = 'meta_value_num';
            } elseif ($settings['product_type'] == 'recent-items') {
                $args['order'] = 'DESC';
                $args['orderby'] = 'date';
            }
        }

        $product_query = new \WP_Query($args);
        ?>
        <?php while ($product_query->have_posts()) :
            $product_query->the_post();
            global $product;
            $regular_price = (float) $product->get_regular_price();
            $sale_price    = (float) $product->get_sale_price();
            $price    = (float) $product->get_price_html();
            $product_title_count = substr(get_the_title(), 0, $settings['post_title_count']['size']);
        ?>
            <div class="sw-product-list__item">
                <?php if (has_post_thumbnail()): ?>
                    <div class="sw-product-list__thumb">
                        <?php the_post_thumbnail('swiftcart_product_60x60'); ?>
                    </div>
                <?php endif; ?>
                <div class="sw-product-list__content">
                    <h3 class="sw-product-list__title el-pd-title"><a href="<?php the_permalink(); ?>"><?php echo wp_kses_post($product_title_count); ?></a></h3>
                    <?php if ($sale_price): ?>
                        <span class="sw-product-list__price el-pd-price"><?php echo wc_price($sale_price); ?></span>
                    <?php else: ?>
                        <span class="sw-product-list__price  el-pd-price"><?php echo wc_price($regular_price); ?></span>
                    <?php endif; ?>
                </div>
            </div>
        <?php endwhile; ?>
    </div>


<?php endif; ?>