<?php if ('layout_four' == $settings['layout_type']) :
    $unique_id = uniqid();
?>
    <!--  best deal start -->
    <div class="sw-best-deal pb-80">
        <div class="container">
            <div class="sw-best-deal__filter-box has-border tabs-box">
                <div class="sw-best-deal__filter-box-wrap mb-20">
                    <ul class="sw-best-deal__filter-btn tab-buttons">
                        <?php if (is_array($settings['product_tab'])) : ?>
                            <?php foreach ($settings['product_tab'] as $index => $item) : ?>
                                <li data-tab="#alldigital-<?php echo esc_attr($index . $unique_id); ?>" class="tab-btn <?php echo esc_attr($active = $index == '0' ? 'active-btn' : '') ?>"><span><?php echo esc_html($item['tab']) ?></span>
                                </li>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </ul>
                </div>
                <?php if (is_array($settings['product_tab'])) : ?>
                    <div class="sw-product-man-woman__wrapper tabs-content">
                        <?php foreach ($settings['product_tab'] as $index => $item) : ?>
                            <div class="tab <?php echo esc_attr($active = $index == '0' ? 'active-tab' : '') ?>" id="alldigital-<?php echo esc_attr($index . $unique_id); ?>">
                                <div class="row gutter-y-30">
                                    <?php
                                    $product_post_one_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

                                    $args  = array(
                                        'post_type'           => 'product',
                                        'post_status'         => 'publish',
                                        'ignore_sticky_posts' => 1,
                                        'posts_per_page'      => $item['post_count']['size'],
                                        'paged' => $product_post_one_query_paged
                                    );

                                    // $args['orderby'] = $settings['orderby'];
                                    // $args['order']   = $settings['order'];
                                    if (!empty($item['exclude_cat'])) {
                                        $args['category__not_in'] = $item['exclude_cat'];
                                    }


                                    if (!empty($item['select_cat'])) {
                                        $args['tax_query'][] = array(
                                            'taxonomy' => 'product_cat',
                                            'field'    => 'slug',
                                            'terms'    => array_values($item['select_cat'])
                                        );
                                    }

                                    if (!empty($item['select_tag'])) {
                                        $args['tax_query'][] = array(
                                            'taxonomy' => 'product_tag',
                                            'field'    => 'slug',
                                            'terms'    => array_values($item['select_tag'])
                                        );
                                    }
                                    if (!empty($item['product_type'])) {
                                        if ($item['product_type'] == 'top-rated') {
                                            $args['meta_key'] = '_wc_average_rating';
                                            $args['order'] = 'DESC';
                                            $args['orderby'] = 'meta_value_num';
                                        } elseif ($item['product_type'] == 'featured') {
                                            $args['order'] = 'DESC';
                                            $args['orderby'] = 'date';
                                            $args['post__in'] = wc_get_featured_product_ids();
                                        } elseif ($item['product_type'] == 'on-sale') {
                                            $args['post__in'] = wc_get_product_ids_on_sale();
                                            $args['order'] = 'ASC';
                                            $args['orderby'] = 'title';
                                        } elseif ($item['product_type'] == 'best-selling') {
                                            $args['meta_key'] = 'total_sales';
                                            $args['order'] = 'DESC';
                                            $args['orderby'] = 'meta_value_num';
                                        } elseif ($item['product_type'] == 'recent-items') {
                                            $args['order'] = 'DESC';
                                            $args['orderby'] = 'date';
                                        }
                                    }

                                    $product_query = new \WP_Query($args);
                                    ?>
                                    <?php while ($product_query->have_posts()) :
                                        $product_query->the_post();
                                        global $product;
                                        $regular_price = (float) $product->get_regular_price();
                                        $sale_price    = (float) $product->get_sale_price();
                                        $price    = (float) $product->get_price_html();
                                    ?>
                                        <div class="col-lg-4 col-md-6">
                                            <div class="sw-product-ten__item">
                                                <?php if (has_post_thumbnail()): ?>
                                                    <div class="sw-product-ten__img w-img">
                                                        <?php the_post_thumbnail('swiftcart_product_420x580'); ?>
                                                    </div>
                                                <?php endif; ?>
                                                <div class="sw-product-ten__content">
                                                    <h3 class="sw-product-ten__title"><a href="product-details.html">women Billie Eilish</a></h3>
                                                    <h4 class="sw-product-ten__price"><?php echo woocommerce_template_loop_price(); ?></h4>
                                                    <div class="sw-product-ten__btn">
                                                        <?php swiftcart_woo_cart_two(); ?>
                                                        <?php if (class_exists('WPCleverWoosq')) : ?>
                                                            <?php echo do_shortcode('[woosq]'); ?>
                                                        <?php endif; ?>
                                                        <?php
                                                        if (class_exists('WPCleverWoosw')) {
                                                            echo do_shortcode('[woosw]');
                                                        }
                                                        ?>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endwhile; ?>

                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    <!--  best deal end -->

<?php endif; ?>