<?php if ('layout_one' == $settings['layout_type']) :
    $unique_id = uniqid();
?>
    <!--  best deal start -->
    <div class="sw-best-deal">
        <div class="container">
            <div class="sw-best-deal__filter-box tabs-box">
                <div class="sw-best-deal__filter-box-wrap">
                    <ul class="sw-best-deal__filter-btn tab-buttons">
                        <?php if (is_array($settings['product_tab'])) : ?>
                            <?php foreach ($settings['product_tab'] as $index => $item) : ?>
                                <li data-tab="#alldigital-<?php echo esc_attr($index . $unique_id); ?>" class="tab-btn <?php echo esc_attr($active = $index == '0' ? 'active-btn' : '') ?>"><span><?php echo esc_html($item['tab']) ?></span>
                                </li>
                            <?php endforeach; ?>
                        <?php endif; ?>

                    </ul>
                    <?php if (!empty($settings['button_label'])) : ?>
                        <div>
                            <a class="sw-best-deal__btn" <?php esc_attr(!empty($settings['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['button_url']['url']); ?>"><?php echo esc_html($settings['button_label']); ?></a>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="sw-product-man-woman__wrapper tabs-content bg-white">
                    <?php if (is_array($settings['product_tab'])) : ?>
                        <?php foreach ($settings['product_tab'] as $index => $item) : ?>
                            <div class="tab <?php echo esc_attr($active = $index == '0' ? 'active-tab' : '') ?>" id="alldigital-<?php echo esc_attr($index . $unique_id); ?>">
                                <div class="row gutter-y-20 row-cols-1  row-cols-sm-2 row row-cols-lg-4 row-cols-xl-5">
                                    <?php
                                    $product_post_one_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

                                    $args  = array(
                                        'post_type'           => 'product',
                                        'post_status'         => 'publish',
                                        'ignore_sticky_posts' => 1,
                                        'posts_per_page'      => $item['post_count']['size'],
                                        'paged' => $product_post_one_query_paged
                                    );

                                    // $args['orderby'] = $settings['orderby'];
                                    // $args['order']   = $settings['order'];
                                    if (!empty($item['exclude_cat'])) {
                                        $args['category__not_in'] = $item['exclude_cat'];
                                    }


                                    if (!empty($item['select_cat'])) {
                                        $args['tax_query'][] = array(
                                            'taxonomy' => 'product_cat',
                                            'field'    => 'slug',
                                            'terms'    => array_values($item['select_cat'])
                                        );
                                    }

                                    if (!empty($item['select_tag'])) {
                                        $args['tax_query'][] = array(
                                            'taxonomy' => 'product_tag',
                                            'field'    => 'slug',
                                            'terms'    => array_values($item['select_tag'])
                                        );
                                    }
                                    if (!empty($item['product_type'])) {
                                        if ($item['product_type'] == 'top-rated') {
                                            $args['meta_key'] = '_wc_average_rating';
                                            $args['order'] = 'DESC';
                                            $args['orderby'] = 'meta_value_num';
                                        } elseif ($item['product_type'] == 'featured') {
                                            $args['order'] = 'DESC';
                                            $args['orderby'] = 'date';
                                            $args['post__in'] = wc_get_featured_product_ids();
                                        } elseif ($item['product_type'] == 'on-sale') {
                                            $args['post__in'] = wc_get_product_ids_on_sale();
                                            $args['order'] = 'ASC';
                                            $args['orderby'] = 'title';
                                        } elseif ($item['product_type'] == 'best-selling') {
                                            $args['meta_key'] = 'total_sales';
                                            $args['order'] = 'DESC';
                                            $args['orderby'] = 'meta_value_num';
                                        } elseif ($item['product_type'] == 'recent-items') {
                                            $args['order'] = 'DESC';
                                            $args['orderby'] = 'date';
                                        }
                                    }

                                    $product_query = new \WP_Query($args);
                                    ?>
                                    <?php while ($product_query->have_posts()) :
                                        $product_query->the_post();
                                        global $product;
                                        $regular_price = (float) $product->get_regular_price();
                                        $sale_price    = (float) $product->get_sale_price();
                                        $price    = (float) $product->get_price_html();
                                        $product_title_count = substr(get_the_title(), 0, $item['post_title_count']['size']);
                                    ?>
                                        <div class="col">
                                            <div class="sw-product-two__item">
                                                <span class="sw-product-two__deal d-none">BEST DEALS</span>
                                                <div class="sw-product-two__img">
                                                    <?php the_post_thumbnail('swiftcart_product_180x180'); ?>
                                                </div>
                                                <div class="sw-product-two__ratting el-pd-ratting">
                                                    <?php echo swiftcart_woo_rating(); ?>
                                                </div>
                                                <h3 class="sw-product-two__title el-pd-title"><a href="<?php the_permalink(); ?>"> <?php echo wp_kses_post($product_title_count); ?></a></h3>
                                                <h4 class="sw-product-two__price el-pd-price"><?php echo woocommerce_template_loop_price(); ?></h4>
                                                <div class="sw-product-two__btn">
                                                    <?php
                                                    if (class_exists('WPCleverWoosw')) {
                                                        echo do_shortcode('[woosw]');
                                                    }
                                                    ?>
                                                    <?php swiftcart_woo_cart_one(); ?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endwhile; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <!--  best deal end -->
<?php endif; ?>