<?php if ('layout_three' == $settings['layout_type']) :
    $unique_id = uniqid();
?>
    <!--  best deal start -->
    <div class="sw-best-deal pt-80 pb-80">
        <div class="container">
            <div class="sw-sec-heading sw-sec-heading-two">
                <span class="sw-sec-heading__subtitle has-before">Best Sale</span>
                <h3 class="sw-sec-heading__title">Best Deals</h3>
            </div>
            <div class="sw-best-deal__filter-box tabs-box">
                <div class="sw-best-deal__filter-box-wrap">
                    <ul class="sw-best-deal__filter-btn tab-buttons">
                        <?php if (is_array($settings['product_tab'])) : ?>
                            <?php foreach ($settings['product_tab'] as $index => $item) : ?>
                                <li data-tab="#alldigital-<?php echo esc_attr($index . $unique_id); ?>" class="tab-btn <?php echo esc_attr($active = $index == '0' ? 'active-btn' : '') ?>"><span><?php echo esc_html($item['tab']) ?></span>
                                </li>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </ul>
                    <?php if (!empty($settings['button_label'])) : ?>
                        <div>
                            <a class="sw-best-deal__btn" <?php esc_attr(!empty($settings['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['button_url']['url']); ?>"><?php echo esc_html($settings['button_label']); ?></a>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="sw-product-man-woman__wrapper tabs-content">
                    <?php if (is_array($settings['product_tab'])) : ?>
                        <?php foreach ($settings['product_tab'] as $index => $item) : ?>
                            <div class="tab <?php echo esc_attr($active = $index == '0' ? 'active-tab' : '') ?>" id="alldigital-<?php echo esc_attr($index . $unique_id); ?>">
                                <div class="row gutter-y-20">
                                    <?php
                                    $product_post_one_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

                                    $args  = array(
                                        'post_type'           => 'product',
                                        'post_status'         => 'publish',
                                        'ignore_sticky_posts' => 1,
                                        'posts_per_page'      => $item['post_count']['size'],
                                        'paged' => $product_post_one_query_paged
                                    );

                                    // $args['orderby'] = $settings['orderby'];
                                    // $args['order']   = $settings['order'];
                                    if (!empty($item['exclude_cat'])) {
                                        $args['category__not_in'] = $item['exclude_cat'];
                                    }


                                    if (!empty($item['select_cat'])) {
                                        $args['tax_query'][] = array(
                                            'taxonomy' => 'product_cat',
                                            'field'    => 'slug',
                                            'terms'    => array_values($item['select_cat'])
                                        );
                                    }

                                    if (!empty($item['select_tag'])) {
                                        $args['tax_query'][] = array(
                                            'taxonomy' => 'product_tag',
                                            'field'    => 'slug',
                                            'terms'    => array_values($item['select_tag'])
                                        );
                                    }
                                    if (!empty($item['product_type'])) {
                                        if ($item['product_type'] == 'top-rated') {
                                            $args['meta_key'] = '_wc_average_rating';
                                            $args['order'] = 'DESC';
                                            $args['orderby'] = 'meta_value_num';
                                        } elseif ($item['product_type'] == 'featured') {
                                            $args['order'] = 'DESC';
                                            $args['orderby'] = 'date';
                                            $args['post__in'] = wc_get_featured_product_ids();
                                        } elseif ($item['product_type'] == 'on-sale') {
                                            $args['post__in'] = wc_get_product_ids_on_sale();
                                            $args['order'] = 'ASC';
                                            $args['orderby'] = 'title';
                                        } elseif ($item['product_type'] == 'best-selling') {
                                            $args['meta_key'] = 'total_sales';
                                            $args['order'] = 'DESC';
                                            $args['orderby'] = 'meta_value_num';
                                        } elseif ($item['product_type'] == 'recent-items') {
                                            $args['order'] = 'DESC';
                                            $args['orderby'] = 'date';
                                        }
                                    }

                                    $product_query = new \WP_Query($args);
                                    ?>
                                    <?php while ($product_query->have_posts()) :
                                        $product_query->the_post();
                                        global $product;
                                        $regular_price = (float) $product->get_regular_price();
                                        $sale_price    = (float) $product->get_sale_price();
                                        $price    = (float) $product->get_price_html();
                                    ?>
                                        <div class="col-md-6 col-lg-4 col-xl-3">
                                            <div class="sw-product-six__item">
                                                <?php
                                                $regular_price = (float) $product->get_regular_price();
                                                $sale_price    = (float) $product->get_sale_price();
                                                $percentage = '';
                                                if ($sale_price != 0 || ! empty($sale_price)) {
                                                    $percentage    = round(100 - ($sale_price / $regular_price * 100)) . '%';
                                                } ?>
                                                <?php if (!empty($percentage)): ?>
                                                    <span class="sw-product-six__offer"><?php echo esc_html($percentage); ?></span>
                                                <?php endif; ?>
                                                <?php if (has_post_thumbnail()): ?>
                                                    <div class="sw-product-six__img">
                                                        <?php the_post_thumbnail('swiftcart_product_180x180'); ?>
                                                    </div>
                                                <?php endif; ?>
                                                <h5 class="sw-product-six__price el-pd-price"><?php echo woocommerce_template_loop_price(); ?></h5>
                                                <h3 class="sw-product-six__title el-pd-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                                                <div class="sw-product-six__ratting el-pd-ratting">
                                                    <?php echo swiftcart_woo_rating(); ?>
                                                </div>
                                                <div class="sw-product-six__btns">
                                                    <?php woocommerce_template_loop_add_to_cart(); ?>
                                                    <?php
                                                    if (class_exists('WPCleverWoosw')) {
                                                        echo do_shortcode('[woosw]');
                                                    }
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endwhile; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <!--  best deal end -->
<?php endif; ?>