<?php if ('layout_two' == $settings['layout_type']) :
    $unique_id = uniqid();
?>
    <!--  best deal start -->
    <div class="sw-best-deal pb-80">
        <div class="container">
            <div class="sw-best-deal__filter-box tabs-box">
                <div class="sw-best-deal__filter-box-wrap">
                    <ul class="sw-best-deal__filter-btn tab-buttons">
                        <?php if (is_array($settings['product_tab'])) : ?>
                            <?php foreach ($settings['product_tab'] as $index => $item) : ?>
                                <li data-tab="#product-tab-<?php echo esc_attr($index . $unique_id); ?>" class="tab-btn <?php echo esc_attr($active = $index == '0' ? 'active-btn' : '') ?>"><span><?php echo esc_html($item['tab']) ?></span>
                                </li>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </ul>
                    <?php if (!empty($settings['button_label'])) : ?>
                        <div>
                            <a class="sw-best-deal__btn " <?php esc_attr(!empty($settings['button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['button_url']['url']); ?>"><?php echo esc_html($settings['button_label']); ?></a>
                        </div>
                    <?php endif; ?>
                </div>
                <div class="row gutter-y-30">
                    <div class="col-lg-3">
                        <div class="sw-best-deal__banner bg-black">
                            <?php if (!empty($settings['title'])) : ?>
                                <p class="sw-best-deal__banner-title"><?php echo wp_kses($settings['title'], 'swiftcart_core_allowed_tags');  ?></p>
                            <?php endif; ?>
                            <?php swiftcart_elementor_rendered_image($settings, 'banner_image'); ?>
                            <?php if (!empty($settings['banner_button_label'])) : ?>
                                <a class="swiftcart-btn" <?php esc_attr(!empty($settings['banner_button_url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($settings['banner_button_url']['url']); ?>"><?php echo esc_html($settings['banner_button_label']); ?> <i class="icon-next"></i></a>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-lg-9 order-first order-lg-last">
                        <div class="sw-product-three__wrapper tabs-content bg-white">
                            <?php if (is_array($settings['product_tab'])) : ?>
                                <?php foreach ($settings['product_tab'] as $index => $item) : ?>
                                    <div class="tab <?php echo esc_attr($active = $index == '0' ? 'active-tab' : '') ?>" id="product-tab-<?php echo esc_attr($index . $unique_id); ?>">
                                        <div class="row g-0 row-cols-2 row-cols-md-4 row-cols-xl-5">
                                            <?php
                                            $product_post_one_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

                                            $args  = array(
                                                'post_type'           => 'product',
                                                'post_status'         => 'publish',
                                                'ignore_sticky_posts' => 1,
                                                'posts_per_page'      => $item['post_count']['size'],
                                                'paged' => $product_post_one_query_paged
                                            );

                                            // $args['orderby'] = $settings['orderby'];
                                            // $args['order']   = $settings['order'];
                                            if (!empty($item['exclude_cat'])) {
                                                $args['category__not_in'] = $item['exclude_cat'];
                                            }


                                            if (!empty($item['select_cat'])) {
                                                $args['tax_query'][] = array(
                                                    'taxonomy' => 'product_cat',
                                                    'field'    => 'slug',
                                                    'terms'    => array_values($item['select_cat'])
                                                );
                                            }

                                            if (!empty($item['select_tag'])) {
                                                $args['tax_query'][] = array(
                                                    'taxonomy' => 'product_tag',
                                                    'field'    => 'slug',
                                                    'terms'    => array_values($item['select_tag'])
                                                );
                                            }
                                            if (!empty($item['product_type'])) {
                                                if ($item['product_type'] == 'top-rated') {
                                                    $args['meta_key'] = '_wc_average_rating';
                                                    $args['order'] = 'DESC';
                                                    $args['orderby'] = 'meta_value_num';
                                                } elseif ($item['product_type'] == 'featured') {
                                                    $args['order'] = 'DESC';
                                                    $args['orderby'] = 'date';
                                                    $args['post__in'] = wc_get_featured_product_ids();
                                                } elseif ($item['product_type'] == 'on-sale') {
                                                    $args['post__in'] = wc_get_product_ids_on_sale();
                                                    $args['order'] = 'ASC';
                                                    $args['orderby'] = 'title';
                                                } elseif ($item['product_type'] == 'best-selling') {
                                                    $args['meta_key'] = 'total_sales';
                                                    $args['order'] = 'DESC';
                                                    $args['orderby'] = 'meta_value_num';
                                                } elseif ($item['product_type'] == 'recent-items') {
                                                    $args['order'] = 'DESC';
                                                    $args['orderby'] = 'date';
                                                }
                                            }

                                            $product_query = new \WP_Query($args);
                                            ?>
                                            <?php while ($product_query->have_posts()) :
                                                $product_query->the_post();
                                                global $product;
                                                $regular_price = (float) $product->get_regular_price();
                                                $sale_price    = (float) $product->get_sale_price();
                                                $price    = (float) $product->get_price_html();
                                                $product_title_count = substr(get_the_title(), 0, $item['post_title_count']['size']);
                                            ?>
                                                <div class="col">
                                                    <div class="sw-product-three__item">
                                                        <div class="sw-product-three__img">
                                                            <?php the_post_thumbnail('swiftcart_product_100x110'); ?>
                                                        </div>
                                                        <div class="sw-product-three__ratting el-pd-ratting">
                                                            <?php echo swiftcart_woo_rating(); ?>
                                                        </div>
                                                        <h3 class="sw-product-three__title el-pd-title"><a href="<?php the_permalink(); ?>"><?php echo wp_kses_post($product_title_count); ?></a></h3>
                                                        <h4 class="sw-product-three__price el-pd-price"><?php echo woocommerce_template_loop_price(); ?></h4>
                                                    </div>
                                                </div>
                                            <?php endwhile; ?>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!--  best deal end -->
<?php endif; ?>