<?php if ('layout_two' == $settings['layout_type']) : ?>
    <?php

    $taxonomy = 'property_cat';

    $categories = get_terms(array(
        'taxonomy' => $taxonomy,
        'hide_empty' => false, // Set to false if you want to retrieve empty categories as well
    ));
    ?>

    <!-- Categores area start -->
    <div class="categores-area bg-gray pd-top-118 pd-bottom-90">
        <div class="container">
            <?php if ('yes' == $settings['heading_status']) : ?>
                <div class="section-title text-center">
                    <?php if (!empty($settings['sub_title'])) : ?>
                        <h6><?php echo esc_html($settings['sub_title']); ?></h6>
                    <?php endif; ?>
                    <?php if (!empty($settings['title'])) : ?>
                        <h2><?php echo wp_kses($settings['title'], 'swiftcart_core_allowed_tags');  ?></h2>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <div class="row">
                <?php foreach ($categories as $index => $category) :
                    $property_type_icon = get_term_meta($category->term_id, 'swiftcart_property_cat_meta', true);
                    $category_permalink = get_term_link($category);
                    if ($index == $settings['cat_count']['size']) {
                        break;
                    }

                ?>
                    <div class="col-lg-4 col-sm-6">
                        <div class="single-category-product-wrap style-two text-center">
                            <?php if (!empty($property_type_icon['property_cat_thumb']['url'])) : ?>
                                <div class="thumb">
                                    <img src="<?php echo esc_url($property_type_icon['property_cat_thumb']['url']) ?>" alt="<?php echo esc_html($meta['property_cat_thumb']['alt']) ?>">
                                </div>
                            <?php endif; ?>
                            <div class="single-category-product-details">
                                <h4><a href="<?php echo esc_url($category_permalink) ?>"><?php esc_html_e($category->name, 'swiftcart-core') ?></a></h4>
                                <a class="btn btn-base" href="<?php echo esc_url($category_permalink) ?>"><?php esc_html_e($category->count . "  Porparties", 'swiftcart-core') ?></a>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
    <!-- Categores area end -->

<?php endif; ?>