<?php $category =  get_the_terms(get_the_ID(), 'category');
// property mete 
$property = get_post_meta(get_the_ID(), 'swiftcart_property_meta', true);
$property_category =  get_the_terms(get_the_ID(), 'property_category');
$property_item_status = get_the_terms(get_the_ID(), 'property_status');
?>

<?php if ('layout_one' == $settings['layout_type']) : ?>
    <div class="property-details-top pd-bottom-70">
        <div class="property-details-top-inner">
            <div class="row">
                <div class="col-lg-7">
                    <h3><?php the_title(); ?></h3>
                    <p><img src="<?php echo get_theme_file_uri() ?>/assets/img/icon/location2.png" alt="img">
                        <?php if (!empty($property['property_location_name'])) :
                            esc_html_e($property['property_location_name'], 'swiftcart');
                        else :
                            esc_html_e("Not Set", 'swiftcart');
                        endif ?></p>
                    <div>
                        <?php if (!empty($property['property_bedrooms'])) : ?>
                            <span><?php echo esc_html($property['property_bedrooms']); ?><span><?php esc_html_e(' Bedroom', 'swiftcart-core') ?></span></span>
                        <?php endif; ?>
                        <?php if (!empty($property['property_bathrooms'])) : ?>
                            <span class="border-none"><?php echo esc_html($property['property_bathrooms']); ?><span><?php esc_html_e(' Bathroom', 'swiftcart-core') ?></span></span>
                        <?php endif; ?>

                        <?php if (!empty($property['property_area'])) : ?>
                            <span><?php echo esc_html($property['property_area']); ?></span>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-lg-5 text-lg-right">
                    <?php if (!empty($property['property_price'])) : ?>
                        <h4><?php echo esc_html($property['property_price']) ?></h4>
                    <?php else : ?>
                        <h4><?php echo esc_html_e("Price Not Set", 'swiftcart') ?></h4>
                    <?php endif; ?>
                    <?php if (is_array($property_item_status)) : ?>
                        <div class="btn-wrap">
                            <?php foreach ($property_item_status as $item) : ?>
                                <a class="btn btn-base btn-sm" href="<?php echo esc_url(get_tag_link($item->term_id)); ?>"><?php echo esc_html($item->name) ?></a>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>
                    <ul>
                        <li><img src="<?php echo get_theme_file_uri() ?>/assets/img/icon/1.png" alt="img"><?php echo get_the_date(); ?></li>
                        <li><img src="<?php echo get_theme_file_uri() ?>/assets/img/icon/2.png" alt="img"><?php echo swiftcart_custom_get_post_views(get_the_ID()); ?></li>
                        <li><img src="<?php echo get_theme_file_uri() ?>/assets/img/icon/3.png" alt="img"><?php comments_popup_link(); ?></li>
                    </ul>
                </div>
            </div>
        </div>
        <div class="product-thumbnail-wrapper">
            <?php if (is_array($settings['gallery_list'])) : ?>
                <div class="single-thumbnail-slider">
                    <?php foreach ($settings['gallery_list'] as $item) : ?>
                        <div class="slider-item">
                            <img src="<?php echo esc_url($item['gallery_photos']['url']); ?>" alt="<?php echo esc_attr(swiftcart_core_get_thumbnail_alt($item['gallery_photos']['id'])); ?>">
                        </div>
                    <?php endforeach; ?>
                </div>

                <div class="product-thumbnail-carousel">
                    <?php foreach ($settings['gallery_list'] as $item) : ?>
                        <div class="single-thumbnail-item">
                            <img src="<?php echo esc_url($item['gallery_photos']['url']); ?>" alt="<?php echo esc_attr(swiftcart_core_get_thumbnail_alt($item['gallery_photos']['id'])); ?>">
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>

<?php endif; ?>

<?php if ('layout_two' == $settings['layout_type']) : ?>
    <div class="single-property-details-inner">
        <?php if (!empty($settings['layout_two_title'])) : ?>
            <h4><?php echo esc_html($settings['layout_two_title']); ?></h4>
        <?php endif; ?>
        <?php if (!empty($settings['layout_two_title'])) : ?>
            <p><?php echo wp_kses($settings['layout_two_summary'], 'swiftcart_core_allowed_tags'); ?></p>
        <?php endif; ?>
        <div class="single-property-grid">
            <h4><?php echo esc_html($settings['layout_two_feature_title']); ?></h4>
            <div class="row">
                <?php foreach ($settings['layout_two_list'] as $list) : ?>
                    <div class="col-md-4">
                        <ul>
                            <?php echo wp_kses($list['list'], 'swiftcart_core_allowed_tags'); ?>
                        </ul>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php if ('layout_three' == $settings['layout_type']) : ?>
    <div class="single-property-grid">
        <h4><?php echo esc_html($settings['layout_three_feature_title']); ?></h4>
        <div class="row">
            <?php foreach ($settings['layout_three_list'] as $index => $list) :  $extra_class = ""; ?>
                <?php if (1 == $index) {
                    $extra_class = "mt-2 mt-sm-0";
                } ?>
                <div class="col-sm-6 <?php echo esc_attr($extra_class); ?>">
                    <a <?php esc_attr(!empty($list['url']['is_external']) ? 'target=_blank' : ' '); ?> href="<?php echo esc_url($list['url']['url']); ?>">
                        <img src="<?php echo esc_url($list['img']['url']); ?>" alt="<?php echo esc_attr(swiftcart_core_get_thumbnail_alt($list['img']['id'])); ?>">
                    </a>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
<?php endif; ?>

<?php if ('layout_four' == $settings['layout_type']) : ?>
    <div class="single-property-grid">
        <h4><?php echo esc_html($settings['layout_four_feature_title']); ?></h4>
        <div class="property-map">
            <iframe src="<?php echo esc_url($settings['layout_four_url']['url']) ?>"></iframe>
        </div>
    </div>
<?php endif; ?>


<?php if ('layout_five' == $settings['layout_type']) : ?>

    <div class="single-property-grid">
        <h4><?php echo esc_html($settings['layout_five_feature_title']); ?></h4>
        <img src="<?php echo esc_url($settings['layout_five_img']['url']) ?>" alt="<?php echo esc_attr(swiftcart_core_get_thumbnail_alt($list['layout_five_img']['id'])); ?>">
    </div>

<?php endif; ?>


<?php if ('layout_six' == $settings['layout_type']) : ?>
    <div class="single-property-grid">
        <h4><?php echo esc_html($settings['layout_six_feature_title']); ?></h4>
        <div class="property-video text-center" style="background: url(<?php echo esc_url($settings['layout_six_img']['url']) ?>);">
            <a class="play-btn" href="<?php echo esc_url($settings['layout_six_url']['url']) ?>" data-effect="mfp-zoom-in"><i class="fa fa-play" aria-hidden="true"></i></a>
        </div>
    </div>
<?php endif; ?>