<?php if ('layout_five' == $settings['layout_type']) : ?>

    <!-- Featured area start -->
    <div class="featured-area pd-top-118 pd-bottom-90">
        <div class="container">
            <?php if ('yes' == $settings['heading_status']) : ?>
                <div class="section-title text-center">
                    <?php if (!empty($settings['sub_title'])) : ?>
                        <h6><?php echo esc_html($settings['sub_title']); ?></h6>
                    <?php endif; ?>
                    <?php if (!empty($settings['title'])) : ?>
                        <h2><?php echo wp_kses($settings['title'], 'swiftcart_core_allowed_tags');  ?></h2>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
            <div class="row">
                <?php
                $property_post_one_query_paged = (get_query_var('paged')) ? get_query_var('paged') : 1;

                $args  = array(
                    'post_type'           => 'property',
                    'post_status'         => 'publish',
                    'ignore_sticky_posts' => 1,
                    'posts_per_page'      => $settings['post_count']['size'],
                    'paged' => $property_post_one_query_paged
                );

                $args['orderby'] = $settings['orderby'];
                $args['order']   = $settings['order'];
                if (!empty($settings['exclude_cat'])) {
                    $args['category__not_in'] = $settings['exclude_cat'];
                }


                if (!empty($settings['select_cat'])) {
                    $args['tax_query'][] = array(
                        'taxonomy' => 'property_status',
                        'field'    => 'slug',
                        'terms'    => array_values($settings['select_cat'])
                    );
                }

                if (!empty($settings['select_tag'])) {
                    $args['tax_query'][] = array(
                        'taxonomy' => 'property_cat',
                        'field'    => 'slug',
                        'terms'    => array_values($settings['select_tag'])
                    );
                }

                $property_query = new \WP_Query($args);
                ?>
                <?php while ($property_query->have_posts()) :
                    $property_query->the_post();

                    $property = get_post_meta(get_the_ID(), 'swiftcart_property_meta', true);
                    $property_category =  get_the_terms(get_the_ID(), 'property_category');
                    $property_item_status = get_the_terms(get_the_ID(), 'property_status');


                ?>
                    <div class="col-md-6">
                        <div class="single-product-wrap">
                            <div class="thumb">
                                <a href="<?php the_permalink() ?>">
                                    <?php the_post_thumbnail('swiftcart_property_610X510'); ?>
                                </a>
                                <div class="btn-area">
                                    <?php if (is_array($property_item_status)) : ?>
                                        <?php foreach ($property_item_status as $item) : ?>
                                            <a class="btn btn-base btn-sm" href="<?php echo esc_url(get_tag_link($item->term_id)); ?>"><?php echo esc_html($item->name) ?></a>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                            <div class="product-wrap-details">
                                <div class="product-details-inner p-0">
                                    <?php if (!empty($property['property_price'])) : ?>
                                        <h4><?php echo esc_html($property['property_price']) ?></h4>
                                    <?php else : ?>
                                        <h4><?php echo esc_html_e("Price Not Set", 'swiftcart') ?></h4>
                                    <?php endif; ?>
                                    <div class="row">
                                        <div class="col-10">
                                            <ul class="meta-inner mb-0">
                                                <li><img src="<?php echo get_theme_file_uri() ?>/assets/img/icon/location2.png" alt="img">
                                                    <?php if (!empty($property['property_location_name'])) :
                                                        esc_html_e($property['property_location_name'], 'swiftcart');
                                                    else :
                                                        esc_html_e("Not Set", 'swiftcart');
                                                    endif ?>
                                                </li>
                                            </ul>
                                        </div>
                                        <div class="col-2 align-self-center">
                                            <a class="wishlist" href="#"><i class="far fa-heart" aria-hidden="true"></i></a>
                                        </div>
                                    </div>
                                </div>
                                <div class="product-meta-bottom style-2 pl-0 pr-0">
                                    <?php if (!empty($property['property_bedrooms'])) : ?>
                                        <span><?php echo esc_html($property['property_bedrooms']); ?><span><?php esc_html_e(' Bedroom', 'swiftcart-core') ?></span></span>
                                    <?php endif; ?>
                                    <?php if (!empty($property['property_bathrooms'])) : ?>
                                        <span class="border-none"><?php echo esc_html($property['property_bathrooms']); ?><span><?php esc_html_e(' Bathroom', 'swiftcart-core') ?></span></span>
                                    <?php endif; ?>

                                    <?php if (!empty($property['property_area'])) : ?>
                                        <span><?php echo esc_html($property['property_area']); ?></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endwhile; ?>
                <?php wp_reset_postdata(); ?>
            </div>
        </div>
    </div>
    <!-- Featured area end -->


<?php endif; ?>